/*
 * Decompiled with CFR 0.152.
 */
package gg.auroramc.aurora.api.dependency;

import com.earth2me.essentials.IEssentials;
import com.earth2me.essentials.IUser;
import gg.auroramc.aurora.api.dependency.Dep;
import java.math.BigDecimal;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class EssentialsAdapter {
    private static EssentialsAdapter instance;
    private final IEssentials ess;

    public EssentialsAdapter(IEssentials ess) {
        this.ess = ess;
    }

    public static EssentialsAdapter getInstance() {
        if (instance != null) {
            return instance;
        }
        Plugin ess = Bukkit.getPluginManager().getPlugin(Dep.ESSENTIALS.getId());
        if (ess != null) {
            instance = new EssentialsAdapter((IEssentials)ess);
        }
        return instance;
    }

    public boolean isIgnoredPlayer(Player source, Player target) {
        return this.ess.getUser(source).isIgnoredPlayer((IUser)this.ess.getUser(target));
    }

    public void depositMoney(Player source, double amount) {
        try {
            this.ess.getUser(source).giveMoney(new BigDecimal(amount));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void withdrawMoney(Player source, double amount) {
        this.ess.getUser(source).takeMoney(new BigDecimal(amount));
    }

    public double getBalance(Player source) {
        return this.ess.getUser(source).getMoney().doubleValue();
    }

    public boolean isEconomyEnabled() {
        return !this.ess.getSettings().isEcoDisabled();
    }
}

