/*
 * Decompiled with CFR 0.152.
 */
package gg.auroramc.aurora.api.expansions;

import gg.auroramc.aurora.Aurora;
import gg.auroramc.aurora.api.expansions.AuroraExpansion;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public class ExpansionManager {
    private final Map<Class<? extends AuroraExpansion>, AuroraExpansion> expansions = new HashMap<Class<? extends AuroraExpansion>, AuroraExpansion>();
    private final Map<Class<? extends AuroraExpansion>, AuroraExpansion> preload = new HashMap<Class<? extends AuroraExpansion>, AuroraExpansion>();

    public <T extends AuroraExpansion> void preloadExpansion(Class<T> clazz) {
        try {
            AuroraExpansion expansion = (AuroraExpansion)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            this.preload.put(clazz, expansion);
            this.expansions.put(clazz, expansion);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            Aurora.logger().severe("Failed to load expansion: " + clazz.getName());
        }
    }

    public <T extends AuroraExpansion> void loadExpansion(Class<T> clazz) {
        try {
            if (this.preload.containsKey(clazz)) {
                AuroraExpansion expansion = this.preload.get(clazz);
                if (expansion.canHook()) {
                    expansion.hook();
                    if (expansion instanceof Listener) {
                        Bukkit.getPluginManager().registerEvents((Listener)expansion, (Plugin)Aurora.getInstance());
                    }
                }
                this.preload.remove(clazz);
            } else {
                AuroraExpansion expansion = (AuroraExpansion)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                if (expansion.canHook()) {
                    this.expansions.put(clazz, expansion);
                    expansion.hook();
                    if (expansion instanceof Listener) {
                        Bukkit.getPluginManager().registerEvents((Listener)expansion, (Plugin)Aurora.getInstance());
                    }
                }
            }
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            Aurora.logger().severe("Failed to load expansion: " + clazz.getName());
        }
    }

    public <T extends AuroraExpansion> T getExpansion(Class<T> clazz) {
        AuroraExpansion expansion = this.expansions.get(clazz);
        if (clazz.isInstance(expansion)) {
            return (T)((AuroraExpansion)clazz.cast(expansion));
        }
        return null;
    }

    public void reloadExpansions() {
        this.expansions.values().forEach(AuroraExpansion::reload);
    }
}

