/*
 * Decompiled with CFR 0.152.
 */
package gg.auroramc.aurora.api.levels;

import gg.auroramc.aurora.Aurora;
import gg.auroramc.aurora.api.reward.Reward;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class LevelMatcher {
    protected final String key;
    protected final Map<String, Reward> rewards;
    protected List<LevelMatcher> parents;

    public LevelMatcher(String key, Map<String, Reward> rewards) {
        this.rewards = rewards;
        this.key = key;
    }

    public List<Reward> computeRewards(int level) {
        return new ArrayList<Reward>(this.resolveRewards(level).values());
    }

    public Map<String, Reward> resolveRewards(int level) {
        return this.resolveRewards(level, new LinkedHashSet<LevelMatcher>());
    }

    private Map<String, Reward> resolveRewards(int level, Set<LevelMatcher> visited) {
        if (this.parents == null && this.matches(level)) {
            return this.rewards;
        }
        if (!visited.add(this)) {
            Aurora.logger().warning("Detected infinite loop in level matcher inheritance chain. Stopping at " + new ArrayList<LevelMatcher>(visited).get(visited.size() - 1).getKey() + " to prevent stack overflow. [" + String.join((CharSequence)" -> ", visited.stream().map(LevelMatcher::getKey).toList()) + " -> " + this.getKey() + "]");
            return Collections.emptyMap();
        }
        LinkedHashMap<String, Reward> collectedRewards = new LinkedHashMap<String, Reward>();
        if (this.parents != null) {
            for (LevelMatcher parent : this.parents) {
                collectedRewards.putAll(parent.resolveRewards(level, visited));
            }
        }
        if (this.matches(level)) {
            collectedRewards.putAll(this.rewards);
        }
        visited.remove(this);
        return collectedRewards;
    }

    public void addParent(LevelMatcher parent) {
        if (this.parents == null) {
            this.parents = new ArrayList<LevelMatcher>();
        }
        this.parents.add(parent);
    }

    public abstract boolean matches(int var1);

    public String getKey() {
        return this.key;
    }

    public Map<String, Reward> getRewards() {
        return this.rewards;
    }
}

