/*
 * Decompiled with CFR 0.152.
 */
package gg.auroramc.aurora.api.levels;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import gg.auroramc.aurora.api.config.premade.ConcreteMatcherConfig;
import gg.auroramc.aurora.api.config.premade.IntervalMatcherConfig;
import gg.auroramc.aurora.api.levels.ConcreteMatcher;
import gg.auroramc.aurora.api.levels.IntervalMatcher;
import gg.auroramc.aurora.api.levels.LevelMatcher;
import gg.auroramc.aurora.api.reward.Reward;
import gg.auroramc.aurora.api.reward.RewardFactory;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.configuration.ConfigurationSection;

public class MatcherManager {
    private final IntervalMatcher dummyMatcher = new IntervalMatcher("dummy", new IntervalMatcherConfig(), Collections.emptyMap());
    private final List<IntervalMatcher> intervalMatchers = Lists.newCopyOnWriteArrayList();
    private final Map<Integer, ConcreteMatcher> customMatchers = Maps.newConcurrentMap();
    private final RewardFactory rewardFactory;

    public MatcherManager(RewardFactory rewardFactory) {
        this.rewardFactory = rewardFactory;
    }

    public void reload(Map<String, IntervalMatcherConfig> matchers, Map<String, ConcreteMatcherConfig> customMatchers) {
        LevelMatcher parent;
        this.intervalMatchers.clear();
        this.customMatchers.clear();
        LinkedHashMap<String, IntervalMatcher> map = new LinkedHashMap<String, IntervalMatcher>(matchers.entrySet().size());
        LinkedHashMap<String, ConcreteMatcher> cMap = new LinkedHashMap<String, ConcreteMatcher>(matchers.entrySet().size());
        for (Map.Entry<String, IntervalMatcherConfig> entry : matchers.entrySet()) {
            map.put(entry.getKey(), this.parseMatcher(entry.getKey(), entry.getValue()));
        }
        for (Map.Entry<String, Object> entry : customMatchers.entrySet()) {
            ConcreteMatcherConfig val = (ConcreteMatcherConfig)entry.getValue();
            String key = entry.getKey();
            cMap.put(key, new ConcreteMatcher(key, val, this.createRewards(val.getRewards())));
        }
        for (IntervalMatcher intervalMatcher : map.values()) {
            if (intervalMatcher.getConfig().getInheritsFrom().isEmpty()) continue;
            for (String inheritKey : intervalMatcher.getConfig().getInheritsFrom()) {
                parent = (IntervalMatcher)map.get(inheritKey);
                if (parent == null) continue;
                intervalMatcher.addParent(parent);
            }
        }
        for (ConcreteMatcher concreteMatcher : cMap.values()) {
            if (!concreteMatcher.getConfig().getInheritsFrom().isEmpty()) {
                for (String inheritKey : concreteMatcher.getConfig().getInheritsFrom()) {
                    parent = (LevelMatcher)map.get(inheritKey);
                    if (parent == null) {
                        parent = (LevelMatcher)cMap.get(inheritKey);
                    }
                    if (parent == null) continue;
                    concreteMatcher.addParent(parent);
                }
            }
            this.customMatchers.put(concreteMatcher.getConfig().getLevel(), concreteMatcher);
        }
        this.intervalMatchers.addAll(map.values().stream().sorted((a, b) -> Integer.compare(b.getConfig().getPriority(), a.getConfig().getPriority())).toList());
    }

    private IntervalMatcher parseMatcher(String key, IntervalMatcherConfig matcher) {
        return new IntervalMatcher(key, matcher, this.createRewards(matcher.getRewards()));
    }

    private Map<String, Reward> createRewards(ConfigurationSection rewards) {
        LinkedHashMap map = Maps.newLinkedHashMap();
        if (rewards == null) {
            return map;
        }
        for (String key : rewards.getKeys(false)) {
            ConfigurationSection config = rewards.getConfigurationSection(key);
            if (config == null) continue;
            this.rewardFactory.createReward(config).ifPresent(reward -> map.put(key, reward));
        }
        return map;
    }

    public LevelMatcher getBestMatcher(int level) {
        if (this.customMatchers.containsKey(level)) {
            return this.customMatchers.get(level);
        }
        for (IntervalMatcher matcher : this.intervalMatchers) {
            if (!matcher.matches(level)) continue;
            return matcher;
        }
        return this.dummyMatcher;
    }

    public IntervalMatcher getDummyMatcher() {
        return this.dummyMatcher;
    }

    public List<IntervalMatcher> getIntervalMatchers() {
        return this.intervalMatchers;
    }

    public Map<Integer, ConcreteMatcher> getCustomMatchers() {
        return this.customMatchers;
    }

    public RewardFactory getRewardFactory() {
        return this.rewardFactory;
    }
}

