/*
 * Decompiled with CFR 0.152.
 */
package gg.auroramc.aurora.api.menu;

import gg.auroramc.aurora.Aurora;
import gg.auroramc.aurora.api.localization.LocalizationProvider;
import gg.auroramc.aurora.api.menu.ItemBuilder;
import gg.auroramc.aurora.api.menu.MenuAction;
import gg.auroramc.aurora.api.menu.MenuEntry;
import gg.auroramc.aurora.api.menu.MenuItem;
import gg.auroramc.aurora.api.menu.Requirement;
import gg.auroramc.aurora.api.message.Placeholder;
import gg.auroramc.aurora.api.message.Text;
import gg.auroramc.aurora.api.util.NamespacedId;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class AuroraMenu
implements InventoryHolder {
    private final Inventory inventory;
    private ItemStack filler;
    private final Map<Integer, List<MenuEntry>> menuItems = new HashMap<Integer, List<MenuEntry>>();
    private Set<Integer> freeSlots;
    private Consumer<Inventory> freeSlotUpdateHandler;
    private Set<Integer> managedSlots;
    private BiConsumer<InventoryClickEvent, Integer> managedSlotClickHandler;
    private LocalizationProvider localizationProvider;
    private List<ItemStack> freeItems;
    private BiConsumer<AuroraMenu, InventoryCloseEvent> closeHandler;
    private final Player player;
    private NamespacedId id;

    public AuroraMenu(Player player, String title, int size, boolean refreshEnabled, Placeholder<?> ... placeholders) {
        this(player, title, size, refreshEnabled, (LocalizationProvider)null, placeholders);
    }

    public AuroraMenu(Player player, String title, int size, boolean refreshEnabled, LocalizationProvider localizationProvider, Placeholder<?> ... placeholders) {
        if (localizationProvider != null) {
            title = localizationProvider.fillVariables(player, title, placeholders);
        }
        this.localizationProvider = localizationProvider;
        this.player = player;
        this.inventory = Bukkit.createInventory((InventoryHolder)this, (int)size, (Component)Text.component(player, title, placeholders));
        this.filler = ItemBuilder.filler();
        if (refreshEnabled) {
            Aurora.getMenuManager().getRefresher().add(this);
        }
    }

    public AuroraMenu(Player player, String title, int size, boolean refreshEnabled, NamespacedId id, Placeholder<?> ... placeholders) {
        this(player, title, size, refreshEnabled, id, (LocalizationProvider)null, placeholders);
    }

    public AuroraMenu(Player player, String title, int size, boolean refreshEnabled, NamespacedId id, LocalizationProvider localizationProvider, Placeholder<?> ... placeholders) {
        this(player, title, size, refreshEnabled, localizationProvider, placeholders);
        this.id = id;
    }

    public AuroraMenu onClose(BiConsumer<AuroraMenu, InventoryCloseEvent> closeHandler) {
        this.closeHandler = closeHandler;
        return this;
    }

    public AuroraMenu onBeforeFreeSlotsUpdate(Consumer<Inventory> freeSlotUpdateHandler) {
        this.freeSlotUpdateHandler = freeSlotUpdateHandler;
        return this;
    }

    public AuroraMenu onManagedSlotClick(BiConsumer<InventoryClickEvent, Integer> managedSlotClickHandler) {
        this.managedSlotClickHandler = managedSlotClickHandler;
        return this;
    }

    public void addItem(MenuItem item, Function<InventoryClickEvent, MenuAction> handler) {
        MenuEntry menuEntry = new MenuEntry(item, handler);
        for (Integer slot : item.getSlots()) {
            if (!this.menuItems.containsKey(slot)) {
                this.menuItems.put(slot, new ArrayList());
            }
            this.menuItems.get(slot).add(menuEntry);
            this.menuItems.get(slot).sort((entry1, entry2) -> Integer.compare(entry2.getPriority(), entry1.getPriority()));
        }
    }

    public void addItem(MenuItem item, Consumer<InventoryClickEvent> handler) {
        MenuEntry menuEntry = new MenuEntry(item, handler);
        for (Integer slot : item.getSlots()) {
            if (!this.menuItems.containsKey(slot)) {
                this.menuItems.put(slot, new ArrayList());
            }
            this.menuItems.get(slot).add(menuEntry);
            this.menuItems.get(slot).sort((entry1, entry2) -> Integer.compare(entry2.getPriority(), entry1.getPriority()));
        }
    }

    public void addItem(MenuItem item) {
        MenuEntry menuEntry = new MenuEntry(item);
        for (Integer slot : item.getSlots()) {
            if (!this.menuItems.containsKey(slot)) {
                this.menuItems.put(slot, new ArrayList());
            }
            this.menuItems.get(slot).add(menuEntry);
            this.menuItems.get(slot).sort((entry1, entry2) -> Integer.compare(entry2.getPriority(), entry1.getPriority()));
        }
    }

    public AuroraMenu addFiller(ItemStack filler) {
        this.filler = filler;
        return this;
    }

    public AuroraMenu freeSlots(List<Integer> slots) {
        if (this.freeSlots == null) {
            this.freeSlots = new HashSet<Integer>(slots.size());
        }
        this.freeSlots.addAll(slots);
        return this;
    }

    public AuroraMenu freeSlots(int start, int end) {
        if (this.freeSlots == null) {
            this.freeSlots = new HashSet<Integer>(end - start);
        }
        for (int i = start; i < end; ++i) {
            this.freeSlots.add(i);
        }
        return this;
    }

    public AuroraMenu freeSlots(int end) {
        return this.freeSlots(0, end);
    }

    public AuroraMenu managedSlots(List<Integer> slots) {
        if (this.managedSlots == null) {
            this.managedSlots = new HashSet<Integer>(slots.size());
        }
        this.managedSlots.addAll(slots);
        return this;
    }

    public AuroraMenu managedSlots(int start, int end) {
        if (this.managedSlots == null) {
            this.managedSlots = new HashSet<Integer>(end - start);
        }
        for (int i = start; i < end; ++i) {
            this.managedSlots.add(i);
        }
        return this;
    }

    public AuroraMenu managedSlots(int end) {
        return this.managedSlots(0, end);
    }

    public AuroraMenu setFreeSlotsContent(List<ItemStack> items) {
        if (this.freeItems == null) {
            this.freeItems = new ArrayList<ItemStack>(items.size());
        }
        this.freeItems.addAll(items);
        return this;
    }

    private void recalcSlotItem(List<MenuEntry> menuEntries, int slot) {
        boolean found = false;
        for (MenuEntry menuEntry : menuEntries) {
            if (found) {
                menuEntry.setActive(false);
                continue;
            }
            ItemBuilder builder = menuEntry.getItem().getItemBuilder();
            if (Requirement.isAllMet(this.player, builder.getConfig().getViewRequirements(), builder.getPlaceholders())) {
                found = true;
                menuEntry.setActive(true);
                Aurora.getMenuManager().getDupeFixer().getMarker().mark(menuEntry.getItem().getItemStack());
                menuEntry.getItem().refresh();
                this.inventory.setItem(slot, menuEntry.getItem().getItemStack());
                continue;
            }
            menuEntry.setActive(false);
        }
    }

    public boolean hasFreeSlots() {
        return this.freeSlots != null;
    }

    public boolean isFreeSlot(int slot) {
        return this.freeSlots != null && this.freeSlots.contains(slot);
    }

    public boolean handleEvent(InventoryClickEvent e) {
        if (this.freeSlots != null && this.freeSlots.contains(e.getSlot())) {
            e.setCancelled(false);
            this.handleFreeSlotUpdate(e.getInventory());
            return false;
        }
        e.setCancelled(true);
        HumanEntity humanEntity = e.getWhoClicked();
        if (!(humanEntity instanceof Player)) {
            return false;
        }
        Player player = (Player)humanEntity;
        if (this.managedSlots != null && this.managedSlots.contains(e.getSlot())) {
            if (this.managedSlotClickHandler != null) {
                this.managedSlotClickHandler.accept(e, e.getSlot());
            }
            return true;
        }
        if (this.menuItems.containsKey(e.getSlot())) {
            List<MenuEntry> menuEntries = this.menuItems.get(e.getSlot());
            for (MenuEntry menuEntry : menuEntries) {
                if (!menuEntry.isActive()) continue;
                MenuAction result = menuEntry.handleEvent(e);
                if (result == MenuAction.REFRESH_SLOT) {
                    this.recalcSlotItem(menuEntries, e.getSlot());
                    player.updateInventory();
                } else if (result == MenuAction.CLOSE) {
                    player.closeInventory();
                } else if (result == MenuAction.REFRESH_MENU) {
                    this.refresh();
                } else if (result == MenuAction.REFRESH_MENU_DELAYED) {
                    this.refreshDelayed(2);
                }
                return true;
            }
        }
        return false;
    }

    public void handleEvent(InventoryCloseEvent e) {
        Aurora.getMenuManager().getRefresher().remove(this);
        if (this.closeHandler != null) {
            this.closeHandler.accept(this, e);
        }
    }

    public void open() {
        this.open(this.player);
    }

    public void open(Player player) {
        this.open(player, true, null);
    }

    public void open(Player player, boolean useScheduler, Consumer<AuroraMenu> onOpen) {
        if (player.isSleeping()) {
            return;
        }
        if (!player.isOnline()) {
            return;
        }
        this.populateInventory(player, false);
        if (useScheduler) {
            player.getScheduler().run((Plugin)Aurora.getInstance(), task -> {
                player.openInventory(this.inventory);
                if (onOpen != null) {
                    onOpen.accept(this);
                }
            }, null);
        } else {
            player.openInventory(this.inventory);
            if (onOpen != null) {
                onOpen.accept(this);
            }
        }
    }

    private void populateInventory(Player player, boolean isRefresh) {
        this.inventory.clear();
        Aurora.getMenuManager().getDupeFixer().getMarker().mark(this.filler);
        int j = 0;
        for (int i = 0; i < this.inventory.getSize(); ++i) {
            if (this.freeSlots != null && this.freeSlots.contains(i)) {
                if (this.freeItems == null || j >= this.freeItems.size()) continue;
                this.inventory.setItem(i, this.freeItems.get(j));
                ++j;
                continue;
            }
            if (this.managedSlots != null && this.managedSlots.contains(i)) continue;
            this.inventory.setItem(i, this.filler);
        }
        for (Map.Entry<Integer, List<MenuEntry>> menuEntries : this.menuItems.entrySet()) {
            boolean found = false;
            for (MenuEntry menuEntry : menuEntries.getValue()) {
                if (found) {
                    menuEntry.setActive(false);
                    continue;
                }
                ItemBuilder builder = menuEntry.getItem().getItemBuilder();
                if (Requirement.isAllMet(player, builder.getConfig().getViewRequirements(), builder.getPlaceholders())) {
                    found = true;
                    menuEntry.setActive(true);
                    Aurora.getMenuManager().getDupeFixer().getMarker().mark(menuEntry.getItem().getItemStack());
                    if (isRefresh && menuEntry.getItem().isRefreshEnabled()) {
                        menuEntry.getItem().refresh();
                    }
                    this.inventory.setItem(menuEntries.getKey().intValue(), menuEntry.getItem().getItemStack());
                    continue;
                }
                menuEntry.setActive(false);
            }
        }
    }

    @NotNull
    public Inventory getInventory() {
        return this.inventory;
    }

    public void refresh() {
        this.player.getScheduler().run((Plugin)Aurora.getInstance(), task -> {
            this.populateInventory(this.player, true);
            this.player.updateInventory();
        }, null);
    }

    public void refreshDelayed(int delayTicks) {
        this.player.getScheduler().runDelayed((Plugin)Aurora.getInstance(), task -> {
            this.populateInventory(this.player, true);
            this.player.updateInventory();
        }, null, (long)delayTicks);
    }

    public void handleFreeSlotUpdate(Inventory inventory) {
        if (this.freeSlotUpdateHandler != null) {
            this.freeSlotUpdateHandler.accept(inventory);
        }
    }

    public Set<Integer> getFreeSlots() {
        return this.freeSlots;
    }

    public Player getPlayer() {
        return this.player;
    }

    public NamespacedId getId() {
        return this.id;
    }

    public void setId(NamespacedId id) {
        this.id = id;
    }
}

