/*
 * Decompiled with CFR 0.152.
 */
package gg.auroramc.aurora.api.message;

import gg.auroramc.aurora.Aurora;
import gg.auroramc.aurora.api.message.Placeholder;
import gg.auroramc.aurora.api.message.Text;
import gg.auroramc.aurora.api.util.TextUtil;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.kyori.adventure.text.Component;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class Chat {
    private static final String[] LEGACY_CODES = new String[]{"&0", "&1", "&2", "&3", "&4", "&5", "&6", "&7", "&8", "&9", "&a", "&b", "&c", "&d", "&e", "&f", "&k", "&l", "&m", "&n", "&o", "&r"};
    private static final String[] MINI_MESSAGE_CODES = new String[]{"<black>", "<dark_blue>", "<dark_green>", "<dark_aqua>", "<dark_red>", "<dark_purple>", "<gold>", "<gray>", "<dark_gray>", "<blue>", "<green>", "<aqua>", "<red>", "<light_purple>", "<yellow>", "<white>", "<obfuscated>", "<bold>", "<strikethrough>", "<underlined>", "<italic>", "<reset>"};

    public static void sendMessage(Player player, String message, Placeholder<?> ... placeholders) {
        String finalMessage = Text.fillPlaceholders(player, message, placeholders);
        player.sendMessage(Aurora.getMiniMessage().deserialize((Object)Chat.translateToMM(finalMessage)));
    }

    public static void sendMessage(Player player, Component component) {
        player.sendMessage(component);
    }

    public static void sendMessage(CommandSender sender, String message, Placeholder<?> ... placeholders) {
        if (sender instanceof Player) {
            Player player = (Player)sender;
            Chat.sendMessage(player, message, placeholders);
            return;
        }
        message = Placeholder.execute(message, placeholders);
        sender.sendMessage(Aurora.getMiniMessage().deserialize((Object)Chat.translateToMM(message)));
    }

    public static String translateColorCodes(String text) {
        String message = text;
        Pattern hexPattern = Pattern.compile("&#([A-Fa-f0-9]{6})");
        Matcher matcher = hexPattern.matcher(message);
        while (matcher.find()) {
            String colorCode = matcher.group(1);
            StringBuilder replacement = new StringBuilder("\u00a7x");
            for (char c : colorCode.toCharArray()) {
                replacement.append('\u00a7').append(c);
            }
            message = message.replace("&#" + colorCode, replacement.toString());
        }
        Pattern bracketHexPattern = Pattern.compile("\\{#([A-Fa-f0-9]{6})\\}");
        matcher = bracketHexPattern.matcher(message);
        while (matcher.find()) {
            String colorCode = matcher.group(1);
            StringBuilder replacement = new StringBuilder("\u00a7x");
            for (char c : colorCode.toCharArray()) {
                replacement.append('\u00a7').append(c);
            }
            message = message.replace("{#" + colorCode + "}", replacement);
        }
        return ChatColor.translateAlternateColorCodes((char)'&', (String)message);
    }

    public static String legacyCodesToMiniMessage(String input) {
        return TextUtil.replaceEach(input, LEGACY_CODES, MINI_MESSAGE_CODES, false, 0);
    }

    public static String translateToMM(String text) {
        String message = Chat.translateHex(text);
        return Chat.legacyCodesToMiniMessage(message);
    }

    public static String translateEverythingToMiniMessage(String text) {
        String message = Chat.translateHex(text);
        Pattern legacyHexPattern = Pattern.compile("\u00a7x\u00a7([A-Fa-f0-9])\u00a7([A-Fa-f0-9])\u00a7([A-Fa-f0-9])\u00a7([A-Fa-f0-9])\u00a7([A-Fa-f0-9])\u00a7([A-Fa-f0-9])");
        Matcher matcher = legacyHexPattern.matcher(message);
        while (matcher.find()) {
            String colorCode = matcher.group(1) + matcher.group(2) + matcher.group(3) + matcher.group(4) + matcher.group(5) + matcher.group(6);
            message = message.replace("\u00a7x\u00a7" + matcher.group(1) + "\u00a7" + matcher.group(2) + "\u00a7" + matcher.group(3) + "\u00a7" + matcher.group(4) + "\u00a7" + matcher.group(5) + "\u00a7" + matcher.group(6), "<#" + colorCode + ">");
        }
        message = message.replaceAll("\u00a7", "&");
        return Chat.legacyCodesToMiniMessage(message);
    }

    private static String translateHex(String text) {
        String message = text;
        Pattern hexPattern = Pattern.compile("&#([A-Fa-f0-9]{6})");
        Matcher matcher = hexPattern.matcher(message);
        while (matcher.find()) {
            String colorCode = matcher.group(1);
            message = message.replace("&#" + colorCode, "<#" + colorCode + ">");
        }
        Pattern bracketHexPattern = Pattern.compile("\\{#([A-Fa-f0-9]{6})}");
        matcher = bracketHexPattern.matcher(message);
        while (matcher.find()) {
            String colorCode = matcher.group(1);
            message = message.replace("{#" + colorCode + "}", "<#" + colorCode + ">");
        }
        return message;
    }
}

