/*
 * Decompiled with CFR 0.152.
 */
package gg.auroramc.aurora.api.message;

import gg.auroramc.aurora.api.util.BooleanSupplier;
import gg.auroramc.aurora.api.util.NumberSupplier;
import gg.auroramc.aurora.api.util.StringSupplier;
import java.util.List;
import java.util.function.Supplier;

public class Placeholder<T> {
    private final String key;
    private final Supplier<T> valueSupplier;

    private Placeholder(String key, T value) {
        this(key, () -> value);
    }

    private Placeholder(String key, Supplier<T> supplier) {
        this.key = key;
        this.valueSupplier = supplier;
    }

    public String replace(String text) {
        T value = this.valueSupplier.get();
        if (value instanceof String) {
            String val = (String)value;
            return text.replace(this.key, val);
        }
        if (value instanceof Number) {
            Number val = (Number)value;
            return text.replace(this.key, String.valueOf(val));
        }
        return text.replace(this.key, this.valueSupplier.get().toString());
    }

    public static Placeholder<String> of(String key, String value) {
        return new Placeholder<String>(key, value);
    }

    public static Placeholder<Number> of(String key, Number value) {
        return new Placeholder<Number>(key, value);
    }

    public static Placeholder<Boolean> of(String key, Boolean value) {
        return new Placeholder<Boolean>(key, value);
    }

    public static Placeholder<String> of(String key, StringSupplier supplier) {
        return new Placeholder<String>(key, supplier);
    }

    public static Placeholder<Number> of(String key, NumberSupplier supplier) {
        return new Placeholder<Number>(key, supplier);
    }

    public static Placeholder<Boolean> of(String key, BooleanSupplier supplier) {
        return new Placeholder<Boolean>(key, supplier);
    }

    public static String execute(String text, Placeholder<?> ... placeholders) {
        if (placeholders == null) {
            return text;
        }
        if (placeholders.length < 1) {
            return text;
        }
        for (Placeholder<?> placeholder : placeholders) {
            text = placeholder.replace(text);
        }
        return text;
    }

    public static String execute(String text, List<Placeholder<?>> placeholders) {
        if (placeholders == null) {
            return text;
        }
        if (placeholders.isEmpty()) {
            return text;
        }
        for (Placeholder<?> placeholder : placeholders) {
            text = placeholder.replace(text);
        }
        return text;
    }

    public T getValue() {
        return this.valueSupplier.get();
    }

    public String toString() {
        return "Placeholder{key='" + this.key + "', value='" + String.valueOf(this.valueSupplier.get()) + "'}";
    }

    public String getKey() {
        return this.key;
    }
}

