/*
 * Decompiled with CFR 0.152.
 */
package gg.auroramc.aurora.api.user.migration;

import gg.auroramc.aurora.Aurora;
import gg.auroramc.aurora.api.user.AuroraUser;
import gg.auroramc.aurora.api.user.UserManager;
import gg.auroramc.aurora.api.user.storage.SaveReason;
import gg.auroramc.aurora.api.user.storage.YamlStorage;
import gg.auroramc.aurora.api.user.storage.sql.MySqlStorage;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Path;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.bukkit.Bukkit;

public class StorageMigrator {
    private final UserManager userManager;
    private final AtomicBoolean migrating = new AtomicBoolean(false);

    public StorageMigrator(UserManager userManager) {
        this.userManager = userManager;
    }

    public boolean migrateUserData(MySqlStorage from, YamlStorage to, int threadCount) {
        try {
            Set<String> uuids;
            ExecutorService executor = Executors.newFixedThreadPool(threadCount);
            AtomicLong counter = new AtomicLong(0L);
            int batchSize = 1000;
            int offset = 0;
            Aurora.logger().info("Starting migration of user data from MySQL to Yaml storage with thread count: " + threadCount);
            while (!(uuids = from.getUserIds(batchSize, offset)).isEmpty()) {
                for (String uuid : uuids) {
                    executor.submit(() -> {
                        UUID parsedId = UUID.fromString(uuid);
                        AuroraUser loadedUser = from.loadUser(parsedId, this.userManager.getDataHolders());
                        loadedUser.setLoaded(true);
                        loadedUser.getDataHolders().forEach(dataHolder -> dataHolder.setDirty(true));
                        to.purgeUser(parsedId);
                        to.saveUser(loadedUser, SaveReason.CUSTOM);
                        long currentCount = counter.incrementAndGet();
                        Aurora.logger().info("[" + currentCount + "] Migrated user data for " + String.valueOf(parsedId) + " with name: " + Bukkit.getOfflinePlayer((UUID)parsedId).getName());
                    });
                }
                offset += batchSize;
            }
            try {
                executor.shutdown();
                boolean success = executor.awaitTermination(1L, TimeUnit.HOURS);
                if (success) {
                    Aurora.logger().info("Successfully migrated all user data for: " + counter.get() + " users.");
                } else {
                    Aurora.logger().severe("Failed to migrate all user data, but " + counter.get() + " users were migrated.");
                }
                return success;
            }
            catch (InterruptedException e) {
                Aurora.logger().severe("Thread interupted while waiting for migration to finish: " + e.getMessage());
                return false;
            }
        }
        catch (Exception e) {
            Aurora.logger().severe("Failed to migrate: " + e.getMessage());
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean migrateUserData(YamlStorage from, MySqlStorage to, int threadCount) {
        boolean bl;
        ExecutorService executor = Executors.newFixedThreadPool(threadCount);
        AtomicLong counter = new AtomicLong(0L);
        Aurora.logger().info("Starting migration of user data from Yaml to MySQL storage with thread count: " + threadCount);
        DirectoryStream<Path> pathStream = from.getFileStream();
        for (Path path : pathStream) {
            executor.submit(() -> {
                UUID uuid = UUID.fromString(path.getFileName().toString().replace(".yml", ""));
                AuroraUser loadedUser = from.loadUser(uuid, this.userManager.getDataHolders());
                loadedUser.setLoaded(true);
                loadedUser.getDataHolders().forEach(dataHolder -> dataHolder.setDirty(true));
                to.purgeUser(uuid);
                to.saveUser(loadedUser, SaveReason.CUSTOM);
                long currentCount = counter.incrementAndGet();
                Aurora.logger().info("[" + currentCount + "] Migrated user data for " + String.valueOf(uuid) + " with name: " + Bukkit.getOfflinePlayer((UUID)uuid).getName());
            });
        }
        try {
            executor.shutdown();
            boolean success = executor.awaitTermination(1L, TimeUnit.HOURS);
            if (success) {
                Aurora.logger().info("Successfully migrated all user data for: " + counter.get() + " users.");
            } else {
                Aurora.logger().severe("Failed to migrate all user data, but " + counter.get() + " users were migrated.");
            }
            bl = success;
        }
        catch (InterruptedException e) {
            try {
                try {
                    Aurora.logger().severe("Thread interupted while waiting for migration to finish: " + e.getMessage());
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    pathStream.close();
                }
                return false;
            }
            catch (IOException e2) {
                Aurora.logger().severe("Failed to get file stream for Yaml storage: " + e2.getMessage());
                return false;
            }
        }
        pathStream.close();
        return bl;
    }

    public boolean isMigrating() {
        return this.migrating.get();
    }

    public void markMigrating() {
        this.migrating.set(true);
    }

    public void markFinished() {
        this.migrating.set(false);
    }
}

