/*
 * Decompiled with CFR 0.152.
 */
package gg.auroramc.aurora.commands;

import gg.auroramc.aurora.Aurora;
import gg.auroramc.aurora.api.localization.LanguageProvider;
import gg.auroramc.aurora.api.message.Chat;
import gg.auroramc.aurora.api.message.Placeholder;
import gg.auroramc.aurora.config.MessageConfig;
import gg.auroramc.aurora.libs.acf.BaseCommand;
import gg.auroramc.aurora.libs.acf.annotation.CommandAlias;
import gg.auroramc.aurora.libs.acf.annotation.CommandCompletion;
import gg.auroramc.aurora.libs.acf.annotation.CommandPermission;
import gg.auroramc.aurora.libs.acf.annotation.Default;
import java.util.Locale;
import org.bukkit.entity.Player;

@CommandAlias(value="language")
public class LanguageCommand
extends BaseCommand {
    @Default
    @CommandCompletion(value="@languages @nothing")
    @CommandPermission(value="aurora.core.user.language")
    public void onLanguageChange(Player player, String language) {
        if (language == null || language.isEmpty()) {
            return;
        }
        LanguageProvider provider = Aurora.getLanguageProvider();
        MessageConfig oldMessages = Aurora.getMsg(player);
        try {
            Locale locale = Locale.forLanguageTag(language);
            if (!provider.getSupportedLocales().contains(locale)) {
                Chat.sendMessage(player, oldMessages.getLocaleNotSupported(), new Placeholder[0]);
                return;
            }
            provider.setPlayerLocale(player, locale);
        }
        catch (Exception e) {
            Chat.sendMessage(player, oldMessages.getLocaleInvalid(), new Placeholder[0]);
        }
        MessageConfig newMessages = Aurora.getMsg(player);
        Chat.sendMessage(player, newMessages.getLocaleChanged(), new Placeholder[0]);
    }
}

