/*
 * Decompiled with CFR 0.152.
 */
package gg.auroramc.aurora.expansions.itemstash;

import gg.auroramc.aurora.Aurora;
import gg.auroramc.aurora.api.item.TypeId;
import gg.auroramc.aurora.api.message.Chat;
import gg.auroramc.aurora.api.message.Placeholder;
import gg.auroramc.aurora.api.user.UserStashHolder;
import gg.auroramc.aurora.api.util.ItemUtils;
import gg.auroramc.aurora.config.MessageConfig;
import gg.auroramc.aurora.expansions.item.ItemExpansion;
import gg.auroramc.aurora.expansions.itemstash.ItemStashExpansion;
import gg.auroramc.aurora.libs.acf.BaseCommand;
import gg.auroramc.aurora.libs.acf.annotation.CommandAlias;
import gg.auroramc.aurora.libs.acf.annotation.CommandCompletion;
import gg.auroramc.aurora.libs.acf.annotation.CommandPermission;
import gg.auroramc.aurora.libs.acf.annotation.Default;
import gg.auroramc.aurora.libs.acf.annotation.Flags;
import gg.auroramc.aurora.libs.acf.annotation.Subcommand;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

@CommandAlias(value="%stashAlias")
public class StashCommand
extends BaseCommand {
    private final ItemStashExpansion expansion;

    public StashCommand(ItemStashExpansion expansion) {
        this.expansion = expansion;
    }

    @Default
    @CommandPermission(value="aurora.core.user.stash.open")
    public void onDefault(Player player) {
        this.expansion.open(player);
    }

    @Subcommand(value="view")
    @CommandPermission(value="aurora.core.admin.stash.other")
    @CommandCompletion(value="@players @nothing")
    public void onView(Player sender, @Flags(value="other") Player target) {
        this.expansion.open(sender, target);
    }

    @Subcommand(value="add")
    @CommandCompletion(value="@players * @range:1-64 true|false @nothing")
    @CommandPermission(value="aurora.core.admin.stash")
    public void onAdd(CommandSender sender, @Flags(value="other") Player player, String itemId, @Default(value="1") Integer amount, @Default(value="false") Boolean silent) {
        MessageConfig messages = Aurora.getMsg(sender);
        ItemStack item = Aurora.getExpansionManager().getExpansion(ItemExpansion.class).getItemManager().resolveItem(TypeId.fromDefault(itemId));
        if (item == null || item.getType() == Material.AIR) {
            if (!silent.booleanValue()) {
                Chat.sendMessage(sender, messages.getItemNotFound(), Placeholder.of("{id}", itemId));
            }
            return;
        }
        ItemStack[] stacks = ItemUtils.createStacksFromAmount(item, amount);
        UserStashHolder stashHolder = Aurora.getUserManager().getUser(player).getStashData();
        for (ItemStack stack : stacks) {
            stashHolder.addItem(stack);
        }
        if (!silent.booleanValue()) {
            Chat.sendMessage(sender, messages.getStashItemAdded(), Placeholder.of("{player}", player.getName()));
        }
    }

    @Subcommand(value="clear")
    @CommandCompletion(value="@players @nothing")
    @CommandPermission(value="aurora.core.admin.stash")
    public void onClear(CommandSender sender, @Flags(value="other") Player player) {
        MessageConfig messages = Aurora.getMsg(sender);
        player.closeInventory();
        Aurora.getUserManager().getUser(player).getStashData().clear();
        Chat.sendMessage(sender, messages.getStashItemsCleared(), new Placeholder[0]);
    }
}

