/*
 * Decompiled with CFR 0.152.
 */
package gg.auroramc.aurora.expansions.itemstash;

import gg.auroramc.aurora.Aurora;
import gg.auroramc.aurora.api.config.premade.ItemConfig;
import gg.auroramc.aurora.api.menu.AuroraMenu;
import gg.auroramc.aurora.api.menu.ItemBuilder;
import gg.auroramc.aurora.api.message.Placeholder;
import gg.auroramc.aurora.api.user.UserStashHolder;
import gg.auroramc.aurora.expansions.itemstash.Config;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.Consumer;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class StashMenu {
    private final Player target;
    private final Player openFor;
    private final Consumer<Player> onClose;
    private Config config;
    private AuroraMenu menu;
    private int page = 0;

    public StashMenu(Player openFor, Player target, Config config, Consumer<Player> onClose) {
        this.openFor = openFor;
        this.target = target;
        this.onClose = onClose;
        this.refresh(config);
    }

    public StashMenu(Player target, Config config, Consumer<Player> onClose) {
        this(target, target, config, onClose);
    }

    public void refresh(Config config) {
        this.config = config;
        this.menu = new AuroraMenu(this.target, config.getMenu().getTitle(), 54, false, Aurora.getLocalizationProvider(), new Placeholder[0]);
        this.menu.onClose((m, e) -> this.onClose.accept(this.target));
        Config.MenuConfig mc = config.getMenu();
        if (mc.getFiller().getEnabled().booleanValue()) {
            this.menu.addFiller(ItemBuilder.of(mc.getFiller().getItem()).toItemStack(this.target));
        } else {
            this.menu.addFiller(ItemBuilder.filler(Material.AIR));
        }
        for (ItemConfig customItem : mc.getCustomItems().values()) {
            this.menu.addItem(ItemBuilder.of(customItem).placeholder(Placeholder.of("{player}", this.target.getName())).build(this.target));
        }
        UserStashHolder stashData = Aurora.getUserManager().getUser(this.target).getStashData();
        List<ItemStack> items = this.getPageItems();
        for (int i = 0; i < config.getStashArea().size(); ++i) {
            Integer menuSlot = config.getStashArea().get(i);
            if (i >= items.size()) {
                this.menu.addItem(ItemBuilder.item(new ItemStack(Material.AIR)).slot(menuSlot).build(this.target));
                continue;
            }
            ItemStack item = items.get(i);
            this.menu.addItem(ItemBuilder.item(item).amount(item.getAmount()).slot(menuSlot).build(this.target), e -> {
                if (stashData.removeItem(item)) {
                    HashMap failed = this.openFor.getInventory().addItem(new ItemStack[]{item});
                    if (!failed.isEmpty()) {
                        this.openFor.getScheduler().run((Plugin)Aurora.getInstance(), task -> failed.forEach((slot, fitem) -> this.openFor.getWorld().dropItem(this.openFor.getLocation(), fitem)), null);
                    }
                    if (this.getMaxPages() <= this.page) {
                        this.page = Math.max(this.getMaxPages() - 1, 0);
                    }
                    this.refresh(config);
                }
            });
        }
        this.menu.addItem(ItemBuilder.of(mc.getItems().getCollectAll()).build(this.target), e -> {
            ArrayList<ItemStack> itemsToRemove = new ArrayList<ItemStack>();
            for (ItemStack item : stashData.getItems()) {
                boolean success = stashData.removeItem(item);
                if (!success) continue;
                itemsToRemove.add(item);
            }
            HashMap failed = this.openFor.getInventory().addItem(itemsToRemove.toArray(new ItemStack[0]));
            if (!failed.isEmpty()) {
                this.openFor.getScheduler().run((Plugin)Aurora.getInstance(), task -> failed.forEach((slot, fitem) -> this.openFor.getWorld().dropItem(this.openFor.getLocation(), fitem)), null);
            }
            if (this.getMaxPages() <= this.page) {
                this.page = Math.max(this.getMaxPages() - 1, 0);
            }
            this.refresh(config);
        });
        if (this.getMaxPages() > 1) {
            this.menu.addItem(ItemBuilder.of(mc.getItems().getPrevPage()).build(this.target), e -> this.prevPage());
            this.menu.addItem(ItemBuilder.of(mc.getItems().getCurrentPage()).placeholder(Placeholder.of("{current}", this.page + 1)).placeholder(Placeholder.of("{max}", this.getMaxPages())).build(this.target));
            this.menu.addItem(ItemBuilder.of(mc.getItems().getNextPage()).build(this.target), e -> this.nextPage());
        }
        this.menu.open(this.openFor);
    }

    private List<ItemStack> getPageItems() {
        int pageSize = this.config.getStashArea().size();
        List<ItemStack> items = Aurora.getUserManager().getUser(this.target).getStashData().getItems();
        return items.subList(this.page * pageSize, Math.min(items.size(), (this.page + 1) * pageSize));
    }

    private int getMaxPages() {
        int pageSize = this.config.getStashArea().size();
        return (int)Math.ceil((double)Aurora.getUserManager().getUser(this.target).getStashData().getItems().size() / (double)pageSize);
    }

    private void nextPage() {
        if (this.page >= this.getMaxPages() - 1) {
            return;
        }
        ++this.page;
        this.refresh(this.config);
    }

    private void prevPage() {
        if (this.page <= 0) {
            return;
        }
        --this.page;
        this.refresh(this.config);
    }
}

