/*
 * Decompiled with CFR 0.152.
 */
package gg.auroramc.aurora.expansions.leaderboard;

import gg.auroramc.aurora.api.AuroraAPI;
import gg.auroramc.aurora.api.message.Placeholder;
import gg.auroramc.aurora.api.message.Text;
import gg.auroramc.aurora.api.placeholder.PlaceholderHandler;
import gg.auroramc.aurora.expansions.leaderboard.LeaderboardExpansion;
import gg.auroramc.aurora.expansions.leaderboard.model.LbEntry;
import java.util.List;
import java.util.stream.Stream;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.entity.Player;

public class LbPlaceholderHandler
implements PlaceholderHandler {
    private final LegacyComponentSerializer serializer = LegacyComponentSerializer.builder().hexColors().useUnusualXRepeatedCharacterHexFormat().build();
    private final LeaderboardExpansion lbm;

    public LbPlaceholderHandler(LeaderboardExpansion leaderboardExpansion) {
        this.lbm = leaderboardExpansion;
    }

    @Override
    public String getIdentifier() {
        return "lb";
    }

    @Override
    public String onPlaceholderRequest(Player player, String[] args) {
        try {
            int index = Integer.parseInt(args[args.length - 1]) - 1;
            String type = args[args.length - 2];
            String boardName = String.join((CharSequence)"_", List.of(args).subList(0, args.length - 2));
            List<LbEntry> list = this.lbm.getBoard(boardName);
            if (list == null) {
                if (player == null) {
                    return this.serializer.serialize(Text.component(this.lbm.getEmptyPlaceholder(), new Placeholder[0]));
                }
                return this.serializer.serialize(Text.component(player, this.lbm.getEmptyPlaceholder(), new Placeholder[0]));
            }
            if (list.size() - 1 < index) {
                if (player == null) {
                    return this.serializer.serialize(Text.component(this.lbm.getEmptyPlaceholder(), new Placeholder[0]));
                }
                return this.serializer.serialize(Text.component(player, this.lbm.getEmptyPlaceholder(), new Placeholder[0]));
            }
            LbEntry entry = list.get(index);
            return switch (type) {
                case "name" -> entry.getName();
                case "value" -> String.valueOf(entry.getValue());
                case "fvalue" -> AuroraAPI.formatNumber(entry.getValue());
                case "cvalue" -> this.lbm.formatValue(entry);
                default -> "Invalid type: " + type;
            };
        }
        catch (Exception ignored) {
            return "Invalid format, try: %aurora_lb_[board]_[name|value|fvalue|cvalue]_[number]%";
        }
    }

    @Override
    public boolean handleNullPlayer() {
        return true;
    }

    @Override
    public List<String> getPatterns() {
        return this.lbm.getBoards().stream().flatMap(board -> Stream.of(board + "_name_[number]%", board + "_value_[number]", board + "_fvalue_[number]", board + "_cvalue_[number]")).toList();
    }
}

