/*
 * Decompiled with CFR 0.152.
 */
package gg.auroramc.aurora.expansions.region;

import gg.auroramc.aurora.Aurora;
import gg.auroramc.aurora.api.events.region.RegionBlockBreakEvent;
import gg.auroramc.aurora.api.events.region.RegionBlockPlaceEvent;
import gg.auroramc.aurora.api.util.Version;
import gg.auroramc.aurora.expansions.region.RegionExpansion;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.entity.Entity;
import org.bukkit.entity.FallingBlock;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPistonExtendEvent;
import org.bukkit.event.block.BlockPistonRetractEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.entity.EntityChangeBlockEvent;
import org.bukkit.event.world.StructureGrowEvent;
import org.bukkit.plugin.Plugin;

public class RegionBlockListener
implements Listener {
    private final Aurora plugin;
    private final RegionExpansion regionExpansion;
    private final BlockFace[] blockFaces = new BlockFace[]{BlockFace.EAST, BlockFace.WEST, BlockFace.NORTH, BlockFace.SOUTH, BlockFace.UP, BlockFace.DOWN};

    public RegionBlockListener(Aurora plugin, RegionExpansion regionExpansion) {
        this.plugin = plugin;
        this.regionExpansion = regionExpansion;
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void checkPlace(BlockPlaceEvent event) {
        Block block = event.getBlock();
        this.regionExpansion.addPlacedBlock(block);
        Bukkit.getPluginManager().callEvent((Event)new RegionBlockPlaceEvent(event.getPlayer(), block));
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onSandFall(EntityChangeBlockEvent event) {
        Block below;
        if (Version.isFolia()) {
            return;
        }
        Block block = event.getBlock();
        if (!this.regionExpansion.isPlacedBlock(block)) {
            return;
        }
        if (!(event.getEntity() instanceof FallingBlock)) {
            return;
        }
        Material type = block.getType();
        if (!(type != Material.SAND && type != Material.RED_SAND && type != Material.GRAVEL || (below = block.getRelative(BlockFace.DOWN)).getType() != Material.AIR && below.getType() != Material.CAVE_AIR && below.getType() != Material.VOID_AIR && below.getType() != Material.WATER && below.getType() != Material.BUBBLE_COLUMN && below.getType() != Material.LAVA)) {
            this.regionExpansion.removePlacedBlock(block);
            Entity entity = event.getEntity();
            AtomicInteger counter = new AtomicInteger();
            Bukkit.getRegionScheduler().runAtFixedRate((Plugin)this.plugin, entity.getLocation(), task -> {
                Block currentBlock = entity.getLocation().getBlock();
                if (entity.isDead() || !entity.isValid()) {
                    if (currentBlock.getType() == type) {
                        this.regionExpansion.addPlacedBlock(entity.getLocation().getBlock());
                    }
                    task.cancel();
                } else if (currentBlock.getType().toString().contains("WEB")) {
                    task.cancel();
                } else if (counter.incrementAndGet() >= 200) {
                    task.cancel();
                }
            }, 1L, 1L);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void checkBreak(BlockBreakEvent event) {
        Block block = event.getBlock();
        Player player = event.getPlayer();
        this.removeBlockWithEvent(player, block);
        this.checkTallPlant(event.getPlayer(), block, 0, mat -> mat == Material.SUGAR_CANE);
        this.checkTallPlant(event.getPlayer(), block, 0, mat -> mat == Material.BAMBOO);
        this.checkTallPlant(event.getPlayer(), block, 0, mat -> mat == Material.CACTUS);
        this.checkTallPlant(event.getPlayer(), block, 0, mat -> mat == Material.KELP_PLANT);
        this.checkBlocksRequiringSupportBelow(event.getPlayer(), block);
        this.checkAmethystCluster(event.getPlayer(), block);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onBlockPistonExtend(BlockPistonExtendEvent event) {
        for (Block block : event.getBlocks()) {
            if (!this.regionExpansion.isPlacedBlock(block)) continue;
            this.regionExpansion.addPlacedBlock(block.getRelative(event.getDirection()));
        }
        this.regionExpansion.removePlacedBlock(event.getBlock().getRelative(event.getDirection()));
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onBlockPistonRetract(BlockPistonRetractEvent event) {
        Block lastBlock = event.getBlock();
        for (Block block : event.getBlocks()) {
            if (!this.regionExpansion.isPlacedBlock(block)) continue;
            this.regionExpansion.addPlacedBlock(block.getRelative(event.getDirection()));
            if (!(block.getLocation().distanceSquared(event.getBlock().getLocation()) > lastBlock.getLocation().distanceSquared(event.getBlock().getLocation()))) continue;
            lastBlock = block;
        }
        if (lastBlock != event.getBlock()) {
            this.regionExpansion.removePlacedBlock(lastBlock);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onStructureGrow(StructureGrowEvent event) {
        int growY = event.getLocation().getBlockY();
        for (BlockState state : event.getBlocks()) {
            if (state.getLocation().getY() != (double)growY) continue;
            this.regionExpansion.removePlacedBlock(state.getBlock());
        }
    }

    private void checkTallPlant(Player player, Block block, int num, Predicate<Material> isMaterial) {
        Block above;
        if (num < 26 && isMaterial.test((above = block.getRelative(BlockFace.UP)).getType())) {
            this.removeBlockWithEvent(player, above);
            this.checkTallPlant(player, above, num + 1, isMaterial);
        }
    }

    private void checkBlocksRequiringSupportBelow(Player player, Block block) {
        Block above = block.getRelative(BlockFace.UP);
        Material source = above.getType();
        if (source == Material.MOSS_CARPET || source == Material.AZALEA || source == Material.FLOWERING_AZALEA || source == Material.PINK_PETALS) {
            this.removeBlockWithEvent(player, above);
        }
    }

    private void checkAmethystCluster(Player player, Block block) {
        for (BlockFace face : this.blockFaces) {
            Block checkedBlock = block.getRelative(face);
            if (Material.AMETHYST_CLUSTER != checkedBlock.getType()) continue;
            this.removeBlockWithEvent(player, checkedBlock);
        }
    }

    private void removeBlockWithEvent(Player player, Block checkedBlock) {
        boolean natural = !this.regionExpansion.isPlacedBlock(checkedBlock);
        Bukkit.getPluginManager().callEvent((Event)new RegionBlockBreakEvent(player, checkedBlock, natural));
        if (!natural) {
            Bukkit.getRegionScheduler().run((Plugin)this.plugin, checkedBlock.getLocation(), t -> this.regionExpansion.removePlacedBlock(checkedBlock));
        }
    }
}

