/*
 * Decompiled with CFR 0.152.
 */
package gg.auroramc.aurora.api.config.premade;

import gg.auroramc.aurora.api.config.premade.PotionConfig;
import gg.auroramc.aurora.api.config.premade.RequirementConfig;
import gg.auroramc.aurora.api.config.premade.SkullConfig;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ItemConfig {
    private boolean refresh;
    private int priority;
    private Boolean hideTooltip;
    private String tooltipStyle;
    private String name;
    private List<String> lore;
    private List<String> appendLore;
    private List<ConditionalLore> conditionalLore;
    private String material;
    private Integer customModelData;
    private String itemModel;
    private String texture;
    private Integer slot;
    private List<Integer> slots;
    private Integer amount;
    private Integer durability;
    private SkullConfig skull;
    private Set<String> flags;
    private PotionConfig potion;
    private Map<String, Integer> enchantments;
    private List<String> onClick;
    private List<String> onLeftClick;
    private List<String> onRightClick;
    private List<String> viewRequirements;
    private List<RequirementConfig> clickRequirements;
    private List<RequirementConfig> leftClickRequirements;
    private List<RequirementConfig> rightClickRequirements;

    public ItemConfig merge(ItemConfig other) {
        if (other == null) {
            return this;
        }
        ItemConfig ret = new ItemConfig(this);
        ret.refresh = other.refresh;
        if (other.name != null) {
            ret.name = other.name;
        }
        if (other.priority != -1) {
            ret.priority = other.priority;
        }
        if (other.lore != null && !other.lore.isEmpty()) {
            ret.lore = new ArrayList<String>(other.lore);
        }
        if (other.appendLore != null && !other.appendLore.isEmpty()) {
            ret.appendLore = new ArrayList<String>(other.appendLore);
        }
        if (other.conditionalLore != null && !other.conditionalLore.isEmpty()) {
            ret.conditionalLore = new ArrayList<ConditionalLore>(other.conditionalLore);
        }
        if (other.hideTooltip != null) {
            ret.hideTooltip = other.hideTooltip;
        }
        if (other.tooltipStyle != null) {
            ret.tooltipStyle = other.tooltipStyle;
        }
        if (other.material != null) {
            ret.material = other.material;
        }
        if (other.customModelData != null) {
            ret.customModelData = other.customModelData;
        }
        if (other.itemModel != null) {
            ret.itemModel = other.itemModel;
        }
        if (other.texture != null) {
            ret.texture = other.texture;
        }
        if (other.slot != null) {
            ret.slot = other.slot;
        }
        if (other.slots != null && !other.slots.isEmpty()) {
            ret.slots = new ArrayList<Integer>(other.slots);
        }
        if (other.amount != null) {
            ret.amount = other.amount;
        }
        if (other.durability != null) {
            ret.durability = other.durability;
        }
        if (other.skull != null) {
            ret.skull = new SkullConfig(other.skull);
        }
        if (other.flags != null && !other.flags.isEmpty()) {
            ret.flags = new HashSet<String>(other.flags);
        }
        if (other.potion != null) {
            ret.potion = new PotionConfig(other.potion);
        }
        if (other.enchantments != null && !other.enchantments.isEmpty()) {
            ret.enchantments = new HashMap<String, Integer>(other.enchantments);
        }
        if (other.viewRequirements != null && !other.viewRequirements.isEmpty()) {
            ret.viewRequirements = new ArrayList<String>(other.viewRequirements);
        }
        if (other.clickRequirements != null && !other.clickRequirements.isEmpty()) {
            ret.clickRequirements = new ArrayList<RequirementConfig>(other.clickRequirements);
        }
        if (other.leftClickRequirements != null && !other.leftClickRequirements.isEmpty()) {
            ret.leftClickRequirements = new ArrayList<RequirementConfig>(other.leftClickRequirements);
        }
        if (other.rightClickRequirements != null && !other.rightClickRequirements.isEmpty()) {
            ret.rightClickRequirements = new ArrayList<RequirementConfig>(other.rightClickRequirements);
        }
        if (other.onClick != null && !other.onClick.isEmpty()) {
            ret.onClick = new ArrayList<String>(other.onClick);
        }
        if (other.onLeftClick != null && !other.onLeftClick.isEmpty()) {
            ret.onLeftClick = new ArrayList<String>(other.onLeftClick);
        }
        if (other.onRightClick != null && !other.onRightClick.isEmpty()) {
            ret.onRightClick = new ArrayList<String>(other.onRightClick);
        }
        return ret;
    }

    public ItemConfig(ItemConfig other) {
        if (other == null) {
            this.enchantments = new HashMap<String, Integer>();
            this.flags = new HashSet<String>();
            this.lore = new ArrayList<String>();
            this.onClick = new ArrayList<String>();
            this.onLeftClick = new ArrayList<String>();
            this.onRightClick = new ArrayList<String>();
            return;
        }
        this.refresh = other.refresh;
        this.priority = other.priority;
        this.name = other.name;
        this.lore = other.lore != null ? new ArrayList<String>(other.lore) : new ArrayList<String>();
        this.appendLore = other.appendLore != null ? new ArrayList<String>(other.appendLore) : new ArrayList<String>();
        this.conditionalLore = other.conditionalLore != null ? new ArrayList<ConditionalLore>(other.conditionalLore) : new ArrayList<ConditionalLore>();
        this.hideTooltip = other.hideTooltip;
        this.tooltipStyle = other.tooltipStyle;
        this.material = other.material;
        this.customModelData = other.customModelData;
        this.itemModel = other.itemModel;
        this.texture = other.texture;
        this.slot = other.slot;
        this.slots = other.slots != null ? new ArrayList<Integer>(other.slots) : new ArrayList<Integer>();
        this.amount = other.amount;
        this.durability = other.durability;
        if (other.skull != null) {
            this.skull = new SkullConfig(other.skull);
        }
        this.flags = other.flags != null ? new HashSet<String>(other.flags) : new HashSet<String>();
        if (other.potion != null) {
            this.potion = new PotionConfig(other.potion);
        }
        this.enchantments = other.enchantments != null ? new HashMap<String, Integer>(other.enchantments) : new HashMap<String, Integer>();
        this.viewRequirements = other.viewRequirements != null ? new ArrayList<String>(other.viewRequirements) : new ArrayList<String>();
        this.clickRequirements = other.clickRequirements != null ? new ArrayList<RequirementConfig>(other.clickRequirements) : new ArrayList<RequirementConfig>();
        this.leftClickRequirements = other.leftClickRequirements != null ? new ArrayList<RequirementConfig>(other.leftClickRequirements) : new ArrayList<RequirementConfig>();
        this.rightClickRequirements = other.rightClickRequirements != null ? new ArrayList<RequirementConfig>(other.rightClickRequirements) : new ArrayList<RequirementConfig>();
        this.onClick = other.onClick != null ? new ArrayList<String>(other.onClick) : new ArrayList<String>();
        this.onLeftClick = other.onLeftClick != null ? new ArrayList<String>(other.onLeftClick) : new ArrayList<String>();
        this.onRightClick = other.onRightClick != null ? new ArrayList<String>(other.onRightClick) : new ArrayList<String>();
    }

    private static boolean $default$refresh() {
        return false;
    }

    private static int $default$priority() {
        return -1;
    }

    private static Integer $default$amount() {
        return 1;
    }

    public static ItemConfigBuilder builder() {
        return new ItemConfigBuilder();
    }

    public void setRefresh(boolean refresh) {
        this.refresh = refresh;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public void setHideTooltip(Boolean hideTooltip) {
        this.hideTooltip = hideTooltip;
    }

    public void setTooltipStyle(String tooltipStyle) {
        this.tooltipStyle = tooltipStyle;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setLore(List<String> lore) {
        this.lore = lore;
    }

    public void setAppendLore(List<String> appendLore) {
        this.appendLore = appendLore;
    }

    public void setConditionalLore(List<ConditionalLore> conditionalLore) {
        this.conditionalLore = conditionalLore;
    }

    public void setMaterial(String material) {
        this.material = material;
    }

    public void setCustomModelData(Integer customModelData) {
        this.customModelData = customModelData;
    }

    public void setItemModel(String itemModel) {
        this.itemModel = itemModel;
    }

    public void setTexture(String texture) {
        this.texture = texture;
    }

    public void setSlot(Integer slot) {
        this.slot = slot;
    }

    public void setSlots(List<Integer> slots) {
        this.slots = slots;
    }

    public void setAmount(Integer amount) {
        this.amount = amount;
    }

    public void setDurability(Integer durability) {
        this.durability = durability;
    }

    public void setSkull(SkullConfig skull) {
        this.skull = skull;
    }

    public void setFlags(Set<String> flags) {
        this.flags = flags;
    }

    public void setPotion(PotionConfig potion) {
        this.potion = potion;
    }

    public void setEnchantments(Map<String, Integer> enchantments) {
        this.enchantments = enchantments;
    }

    public void setOnClick(List<String> onClick) {
        this.onClick = onClick;
    }

    public void setOnLeftClick(List<String> onLeftClick) {
        this.onLeftClick = onLeftClick;
    }

    public void setOnRightClick(List<String> onRightClick) {
        this.onRightClick = onRightClick;
    }

    public void setViewRequirements(List<String> viewRequirements) {
        this.viewRequirements = viewRequirements;
    }

    public void setClickRequirements(List<RequirementConfig> clickRequirements) {
        this.clickRequirements = clickRequirements;
    }

    public void setLeftClickRequirements(List<RequirementConfig> leftClickRequirements) {
        this.leftClickRequirements = leftClickRequirements;
    }

    public void setRightClickRequirements(List<RequirementConfig> rightClickRequirements) {
        this.rightClickRequirements = rightClickRequirements;
    }

    public boolean isRefresh() {
        return this.refresh;
    }

    public int getPriority() {
        return this.priority;
    }

    public Boolean getHideTooltip() {
        return this.hideTooltip;
    }

    public String getTooltipStyle() {
        return this.tooltipStyle;
    }

    public String getName() {
        return this.name;
    }

    public List<String> getLore() {
        return this.lore;
    }

    public List<String> getAppendLore() {
        return this.appendLore;
    }

    public List<ConditionalLore> getConditionalLore() {
        return this.conditionalLore;
    }

    public String getMaterial() {
        return this.material;
    }

    public Integer getCustomModelData() {
        return this.customModelData;
    }

    public String getItemModel() {
        return this.itemModel;
    }

    public String getTexture() {
        return this.texture;
    }

    public Integer getSlot() {
        return this.slot;
    }

    public List<Integer> getSlots() {
        return this.slots;
    }

    public Integer getAmount() {
        return this.amount;
    }

    public Integer getDurability() {
        return this.durability;
    }

    public SkullConfig getSkull() {
        return this.skull;
    }

    public Set<String> getFlags() {
        return this.flags;
    }

    public PotionConfig getPotion() {
        return this.potion;
    }

    public Map<String, Integer> getEnchantments() {
        return this.enchantments;
    }

    public List<String> getOnClick() {
        return this.onClick;
    }

    public List<String> getOnLeftClick() {
        return this.onLeftClick;
    }

    public List<String> getOnRightClick() {
        return this.onRightClick;
    }

    public List<String> getViewRequirements() {
        return this.viewRequirements;
    }

    public List<RequirementConfig> getClickRequirements() {
        return this.clickRequirements;
    }

    public List<RequirementConfig> getLeftClickRequirements() {
        return this.leftClickRequirements;
    }

    public List<RequirementConfig> getRightClickRequirements() {
        return this.rightClickRequirements;
    }

    public ItemConfig(boolean refresh, int priority, Boolean hideTooltip, String tooltipStyle, String name, List<String> lore, List<String> appendLore, List<ConditionalLore> conditionalLore, String material, Integer customModelData, String itemModel, String texture, Integer slot, List<Integer> slots, Integer amount, Integer durability, SkullConfig skull, Set<String> flags, PotionConfig potion, Map<String, Integer> enchantments, List<String> onClick, List<String> onLeftClick, List<String> onRightClick, List<String> viewRequirements, List<RequirementConfig> clickRequirements, List<RequirementConfig> leftClickRequirements, List<RequirementConfig> rightClickRequirements) {
        this.refresh = refresh;
        this.priority = priority;
        this.hideTooltip = hideTooltip;
        this.tooltipStyle = tooltipStyle;
        this.name = name;
        this.lore = lore;
        this.appendLore = appendLore;
        this.conditionalLore = conditionalLore;
        this.material = material;
        this.customModelData = customModelData;
        this.itemModel = itemModel;
        this.texture = texture;
        this.slot = slot;
        this.slots = slots;
        this.amount = amount;
        this.durability = durability;
        this.skull = skull;
        this.flags = flags;
        this.potion = potion;
        this.enchantments = enchantments;
        this.onClick = onClick;
        this.onLeftClick = onLeftClick;
        this.onRightClick = onRightClick;
        this.viewRequirements = viewRequirements;
        this.clickRequirements = clickRequirements;
        this.leftClickRequirements = leftClickRequirements;
        this.rightClickRequirements = rightClickRequirements;
    }

    public ItemConfig() {
        this.refresh = ItemConfig.$default$refresh();
        this.priority = ItemConfig.$default$priority();
        this.amount = ItemConfig.$default$amount();
    }

    public static class ItemConfigBuilder {
        private boolean refresh$set;
        private boolean refresh$value;
        private boolean priority$set;
        private int priority$value;
        private Boolean hideTooltip;
        private String tooltipStyle;
        private String name;
        private List<String> lore;
        private List<String> appendLore;
        private List<ConditionalLore> conditionalLore;
        private String material;
        private Integer customModelData;
        private String itemModel;
        private String texture;
        private Integer slot;
        private List<Integer> slots;
        private boolean amount$set;
        private Integer amount$value;
        private Integer durability;
        private SkullConfig skull;
        private Set<String> flags;
        private PotionConfig potion;
        private Map<String, Integer> enchantments;
        private List<String> onClick;
        private List<String> onLeftClick;
        private List<String> onRightClick;
        private List<String> viewRequirements;
        private List<RequirementConfig> clickRequirements;
        private List<RequirementConfig> leftClickRequirements;
        private List<RequirementConfig> rightClickRequirements;

        ItemConfigBuilder() {
        }

        public ItemConfigBuilder refresh(boolean refresh) {
            this.refresh$value = refresh;
            this.refresh$set = true;
            return this;
        }

        public ItemConfigBuilder priority(int priority) {
            this.priority$value = priority;
            this.priority$set = true;
            return this;
        }

        public ItemConfigBuilder hideTooltip(Boolean hideTooltip) {
            this.hideTooltip = hideTooltip;
            return this;
        }

        public ItemConfigBuilder tooltipStyle(String tooltipStyle) {
            this.tooltipStyle = tooltipStyle;
            return this;
        }

        public ItemConfigBuilder name(String name) {
            this.name = name;
            return this;
        }

        public ItemConfigBuilder lore(List<String> lore) {
            this.lore = lore;
            return this;
        }

        public ItemConfigBuilder appendLore(List<String> appendLore) {
            this.appendLore = appendLore;
            return this;
        }

        public ItemConfigBuilder conditionalLore(List<ConditionalLore> conditionalLore) {
            this.conditionalLore = conditionalLore;
            return this;
        }

        public ItemConfigBuilder material(String material) {
            this.material = material;
            return this;
        }

        public ItemConfigBuilder customModelData(Integer customModelData) {
            this.customModelData = customModelData;
            return this;
        }

        public ItemConfigBuilder itemModel(String itemModel) {
            this.itemModel = itemModel;
            return this;
        }

        public ItemConfigBuilder texture(String texture) {
            this.texture = texture;
            return this;
        }

        public ItemConfigBuilder slot(Integer slot) {
            this.slot = slot;
            return this;
        }

        public ItemConfigBuilder slots(List<Integer> slots) {
            this.slots = slots;
            return this;
        }

        public ItemConfigBuilder amount(Integer amount) {
            this.amount$value = amount;
            this.amount$set = true;
            return this;
        }

        public ItemConfigBuilder durability(Integer durability) {
            this.durability = durability;
            return this;
        }

        public ItemConfigBuilder skull(SkullConfig skull) {
            this.skull = skull;
            return this;
        }

        public ItemConfigBuilder flags(Set<String> flags) {
            this.flags = flags;
            return this;
        }

        public ItemConfigBuilder potion(PotionConfig potion) {
            this.potion = potion;
            return this;
        }

        public ItemConfigBuilder enchantments(Map<String, Integer> enchantments) {
            this.enchantments = enchantments;
            return this;
        }

        public ItemConfigBuilder onClick(List<String> onClick) {
            this.onClick = onClick;
            return this;
        }

        public ItemConfigBuilder onLeftClick(List<String> onLeftClick) {
            this.onLeftClick = onLeftClick;
            return this;
        }

        public ItemConfigBuilder onRightClick(List<String> onRightClick) {
            this.onRightClick = onRightClick;
            return this;
        }

        public ItemConfigBuilder viewRequirements(List<String> viewRequirements) {
            this.viewRequirements = viewRequirements;
            return this;
        }

        public ItemConfigBuilder clickRequirements(List<RequirementConfig> clickRequirements) {
            this.clickRequirements = clickRequirements;
            return this;
        }

        public ItemConfigBuilder leftClickRequirements(List<RequirementConfig> leftClickRequirements) {
            this.leftClickRequirements = leftClickRequirements;
            return this;
        }

        public ItemConfigBuilder rightClickRequirements(List<RequirementConfig> rightClickRequirements) {
            this.rightClickRequirements = rightClickRequirements;
            return this;
        }

        public ItemConfig build() {
            boolean refresh$value = this.refresh$value;
            if (!this.refresh$set) {
                refresh$value = ItemConfig.$default$refresh();
            }
            int priority$value = this.priority$value;
            if (!this.priority$set) {
                priority$value = ItemConfig.$default$priority();
            }
            Integer amount$value = this.amount$value;
            if (!this.amount$set) {
                amount$value = ItemConfig.$default$amount();
            }
            return new ItemConfig(refresh$value, priority$value, this.hideTooltip, this.tooltipStyle, this.name, this.lore, this.appendLore, this.conditionalLore, this.material, this.customModelData, this.itemModel, this.texture, this.slot, this.slots, amount$value, this.durability, this.skull, this.flags, this.potion, this.enchantments, this.onClick, this.onLeftClick, this.onRightClick, this.viewRequirements, this.clickRequirements, this.leftClickRequirements, this.rightClickRequirements);
        }

        public String toString() {
            return "ItemConfig.ItemConfigBuilder(refresh$value=" + this.refresh$value + ", priority$value=" + this.priority$value + ", hideTooltip=" + this.hideTooltip + ", tooltipStyle=" + this.tooltipStyle + ", name=" + this.name + ", lore=" + String.valueOf(this.lore) + ", appendLore=" + String.valueOf(this.appendLore) + ", conditionalLore=" + String.valueOf(this.conditionalLore) + ", material=" + this.material + ", customModelData=" + this.customModelData + ", itemModel=" + this.itemModel + ", texture=" + this.texture + ", slot=" + this.slot + ", slots=" + String.valueOf(this.slots) + ", amount$value=" + this.amount$value + ", durability=" + this.durability + ", skull=" + String.valueOf(this.skull) + ", flags=" + String.valueOf(this.flags) + ", potion=" + String.valueOf(this.potion) + ", enchantments=" + String.valueOf(this.enchantments) + ", onClick=" + String.valueOf(this.onClick) + ", onLeftClick=" + String.valueOf(this.onLeftClick) + ", onRightClick=" + String.valueOf(this.onRightClick) + ", viewRequirements=" + String.valueOf(this.viewRequirements) + ", clickRequirements=" + String.valueOf(this.clickRequirements) + ", leftClickRequirements=" + String.valueOf(this.leftClickRequirements) + ", rightClickRequirements=" + String.valueOf(this.rightClickRequirements) + ")";
        }
    }

    public static final class ConditionalLore {
        private List<String> conditions;
        private List<String> lore;

        private static List<String> $default$conditions() {
            return new ArrayList<String>();
        }

        private static List<String> $default$lore() {
            return new ArrayList<String>();
        }

        public static ConditionalLoreBuilder builder() {
            return new ConditionalLoreBuilder();
        }

        public List<String> getConditions() {
            return this.conditions;
        }

        public List<String> getLore() {
            return this.lore;
        }

        public void setConditions(List<String> conditions) {
            this.conditions = conditions;
        }

        public void setLore(List<String> lore) {
            this.lore = lore;
        }

        public ConditionalLore(List<String> conditions, List<String> lore) {
            this.conditions = conditions;
            this.lore = lore;
        }

        public ConditionalLore() {
            this.conditions = ConditionalLore.$default$conditions();
            this.lore = ConditionalLore.$default$lore();
        }

        public static class ConditionalLoreBuilder {
            private boolean conditions$set;
            private List<String> conditions$value;
            private boolean lore$set;
            private List<String> lore$value;

            ConditionalLoreBuilder() {
            }

            public ConditionalLoreBuilder conditions(List<String> conditions) {
                this.conditions$value = conditions;
                this.conditions$set = true;
                return this;
            }

            public ConditionalLoreBuilder lore(List<String> lore) {
                this.lore$value = lore;
                this.lore$set = true;
                return this;
            }

            public ConditionalLore build() {
                List<String> conditions$value = this.conditions$value;
                if (!this.conditions$set) {
                    conditions$value = ConditionalLore.$default$conditions();
                }
                List<String> lore$value = this.lore$value;
                if (!this.lore$set) {
                    lore$value = ConditionalLore.$default$lore();
                }
                return new ConditionalLore(conditions$value, lore$value);
            }

            public String toString() {
                return "ItemConfig.ConditionalLore.ConditionalLoreBuilder(conditions$value=" + String.valueOf(this.conditions$value) + ", lore$value=" + String.valueOf(this.lore$value) + ")";
            }
        }
    }
}

