/*
 * Decompiled with CFR 0.152.
 */
package gg.auroramc.aurora.api.expression;

import gg.auroramc.aurora.api.message.Placeholder;
import gg.auroramc.aurora.api.message.Text;
import gg.auroramc.aurora.libs.exp4j.Expression;
import gg.auroramc.aurora.libs.exp4j.ExpressionBuilder;
import java.util.List;
import org.bukkit.entity.Player;

public class NumberExpression {
    private final Expression expression;

    public NumberExpression(String expression, String ... variables) {
        this.expression = new ExpressionBuilder(expression).variables(variables).build();
    }

    public NumberExpression(String expression, List<String> variables) {
        this.expression = new ExpressionBuilder(expression).variables((String[])variables.toArray(String[]::new)).build();
    }

    public NumberExpression(String expression) {
        this.expression = new ExpressionBuilder(expression).build();
    }

    public double evaluate(Placeholder<?> ... variables) {
        for (Placeholder<?> variable : variables) {
            Object obj = variable.getValue();
            if (!(obj instanceof Number)) continue;
            Number num = (Number)obj;
            this.expression.setVariable(variable.getKey(), num.doubleValue());
        }
        return this.expression.evaluate();
    }

    public double evaluate() {
        return this.expression.evaluate();
    }

    public double evaluate(List<Placeholder<?>> variables) {
        for (Placeholder<?> variable : variables) {
            Object obj = variable.getValue();
            if (!(obj instanceof Number)) continue;
            Number num = (Number)obj;
            this.expression.setVariable(variable.getKey(), num.doubleValue());
        }
        return this.expression.evaluate();
    }

    public static double eval(String expression, Placeholder<?> ... variables) {
        return new NumberExpression(Text.fillPlaceholders(expression, variables)).evaluate();
    }

    public static double eval(String expression, List<Placeholder<?>> variables) {
        return new NumberExpression(Text.fillPlaceholders(expression, variables)).evaluate();
    }

    public static double eval(Player player, String expression, Placeholder<?> ... variables) {
        return new NumberExpression(Text.fillPlaceholders(player, expression, variables)).evaluate();
    }

    public static double eval(Player player, String expression, List<Placeholder<?>> variables) {
        return new NumberExpression(Text.fillPlaceholders(player, expression, variables)).evaluate();
    }

    public static double eval(String expression) {
        return new NumberExpression(expression).evaluate();
    }
}

