/*
 * Decompiled with CFR 0.152.
 */
package gg.auroramc.aurora.api.item;

import java.util.Arrays;
import java.util.Locale;
import org.bukkit.Material;
import org.bukkit.entity.EntityType;

public record TypeId(String namespace, String id) {
    @Override
    public String toString() {
        return this.namespace + ":" + this.id;
    }

    public static TypeId fromString(String string) {
        String[] split = string.split(":");
        if (split.length != 2) {
            return TypeId.fromDefault(string);
        }
        return new TypeId(split[0], split[0].equalsIgnoreCase("minecraft") ? split[1].toLowerCase(Locale.ROOT) : split[1]);
    }

    public static TypeId fromDefault(String string) {
        String[] split = string.split(":");
        if (split.length == 1) {
            return new TypeId("minecraft", split[0].toLowerCase(Locale.ROOT));
        }
        if (split.length != 2) {
            String rest = String.join((CharSequence)":", Arrays.copyOfRange(split, 1, split.length));
            return new TypeId(split[0], rest);
        }
        return new TypeId(split[0], split[1]);
    }

    public static TypeId from(Material material) {
        return new TypeId("minecraft", material.name().toLowerCase(Locale.ROOT));
    }

    public static TypeId from(EntityType entityType) {
        return new TypeId("minecraft", entityType.name().toLowerCase(Locale.ROOT));
    }
}

