/*
 * Decompiled with CFR 0.152.
 */
package gg.auroramc.aurora.api.localization;

import gg.auroramc.aurora.api.localization.LanguageProvider;
import gg.auroramc.aurora.api.message.Placeholder;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.entity.Player;

public class LocalizationProvider
implements LanguageProvider {
    private final Map<Locale, Map<String, String>> values = new ConcurrentHashMap<Locale, Map<String, String>>();
    private final LanguageProvider languageProvider;
    private boolean usePerPlayerLocale = false;
    private static final int MAX_RECURSION = 10;

    public LocalizationProvider(LanguageProvider languageProvider, boolean usePerPlayerLocale) {
        this.languageProvider = languageProvider;
        this.usePerPlayerLocale = usePerPlayerLocale;
    }

    public LocalizationProvider(LanguageProvider languageProvider) {
        this(languageProvider, false);
    }

    @Override
    public Locale getPlayerLocale(Player player) {
        return this.languageProvider.getPlayerLocale(player);
    }

    @Override
    public void setPlayerLocale(Player player, Locale locale) {
        this.languageProvider.setPlayerLocale(player, locale);
    }

    @Override
    public Locale getFallbackLocale() {
        return this.languageProvider.getFallbackLocale();
    }

    @Override
    public void setFallbackLocale(Locale locale) {
        this.languageProvider.setFallbackLocale(locale);
    }

    @Override
    public List<Locale> getSupportedLocales() {
        return this.languageProvider.getSupportedLocales();
    }

    @Override
    public void setSupportedLocales(List<Locale> locales) {
        this.languageProvider.setSupportedLocales(locales);
    }

    public void clear() {
        this.values.clear();
    }

    public void setLocaleValues(Locale locale, Map<String, String> values) {
        this.values.put(locale, values);
    }

    public String fillVariables(Player player, String input, Placeholder<?> ... placeholders) {
        return this.fillVariables(this.getPlayerLocale(player), input, placeholders);
    }

    public String fillVariables(Locale locale, String input, Placeholder<?> ... placeholders) {
        if (input == null || input.isEmpty()) {
            return input;
        }
        Map<String, String> primary = this.values.get(locale != Locale.ROOT ? locale : this.languageProvider.getFallbackLocale());
        Map<String, String> fallback = this.values.get(this.languageProvider.getFallbackLocale());
        if (primary == null) {
            primary = Collections.emptyMap();
        }
        if (fallback == null) {
            fallback = Collections.emptyMap();
        }
        return this.resolveRecursive(input, primary, fallback, placeholders, 0);
    }

    public String fillVariables(Player player, String input, List<Placeholder<?>> placeholders) {
        return this.fillVariables(this.usePerPlayerLocale ? this.getPlayerLocale(player) : this.getFallbackLocale(), input, placeholders);
    }

    public String fillVariables(Locale locale, String input, List<Placeholder<?>> placeholders) {
        if (input == null || input.isEmpty()) {
            return input;
        }
        Map<String, String> primary = this.values.get(locale != Locale.ROOT ? locale : this.languageProvider.getFallbackLocale());
        Map<String, String> fallback = this.values.get(this.languageProvider.getFallbackLocale());
        if (primary == null) {
            primary = Collections.emptyMap();
        }
        if (fallback == null) {
            fallback = Collections.emptyMap();
        }
        return this.resolveRecursive(input, primary, fallback, placeholders, 0);
    }

    private String resolveRecursive(String input, Map<String, String> primary, Map<String, String> fallback, Placeholder<?>[] placeholders, int depth) {
        if (depth > 10 || input == null || input.isEmpty()) {
            return input;
        }
        StringBuilder out = new StringBuilder(input.length());
        boolean replaced = false;
        int len = input.length();
        int i = 0;
        while (i < len) {
            int close;
            char c = input.charAt(i);
            if (c == '{' && i + 1 < len && input.charAt(i + 1) == '{' && (close = input.indexOf("}}", i + 2)) != -1) {
                String key = input.substring(i + 2, close);
                String val = primary.getOrDefault(key, fallback.get(key));
                if (val != null) {
                    out.append(val);
                    replaced = true;
                } else {
                    out.append("{{").append(key).append("}}");
                }
                i = close + 2;
                continue;
            }
            out.append(c);
            ++i;
        }
        String result = out.toString();
        String newResult = Placeholder.execute(result, placeholders);
        replaced = replaced || !newResult.equals(result);
        result = newResult;
        return replaced ? this.resolveRecursive(result, primary, fallback, placeholders, depth + 1) : result;
    }

    private String resolveRecursive(String input, Map<String, String> primary, Map<String, String> fallback, List<Placeholder<?>> placeholders, int depth) {
        if (depth > 10 || input == null || input.isEmpty()) {
            return input;
        }
        StringBuilder out = new StringBuilder(input.length());
        boolean replaced = false;
        int len = input.length();
        int i = 0;
        while (i < len) {
            int close;
            char c = input.charAt(i);
            if (c == '{' && i + 1 < len && input.charAt(i + 1) == '{' && (close = input.indexOf("}}", i + 2)) != -1) {
                String key = input.substring(i + 2, close);
                String val = primary.getOrDefault(key, fallback.get(key));
                if (val != null) {
                    out.append(val);
                    replaced = true;
                } else {
                    out.append("{{").append(key).append("}}");
                }
                i = close + 2;
                continue;
            }
            out.append(c);
            ++i;
        }
        String result = out.toString();
        String newResult = Placeholder.execute(result, placeholders);
        replaced = replaced || !newResult.equals(result);
        result = newResult;
        return replaced ? this.resolveRecursive(result, primary, fallback, placeholders, depth + 1) : result;
    }
}

