/*
 * Decompiled with CFR 0.152.
 */
package gg.auroramc.aurora.api.menu;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import gg.auroramc.aurora.Aurora;
import gg.auroramc.aurora.api.config.premade.ItemConfig;
import gg.auroramc.aurora.api.config.premade.SkullConfig;
import gg.auroramc.aurora.api.item.TypeId;
import gg.auroramc.aurora.api.localization.LocalizationProvider;
import gg.auroramc.aurora.api.menu.MenuItem;
import gg.auroramc.aurora.api.menu.Requirement;
import gg.auroramc.aurora.api.message.ComponentWrapper;
import gg.auroramc.aurora.api.message.Placeholder;
import gg.auroramc.aurora.api.message.Text;
import gg.auroramc.aurora.api.util.BukkitPotionType;
import gg.auroramc.aurora.api.util.Version;
import gg.auroramc.aurora.expansions.item.ItemExpansion;
import java.net.URI;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.function.Supplier;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionType;
import org.bukkit.profile.PlayerProfile;
import org.bukkit.profile.PlayerTextures;
import org.jetbrains.annotations.Nullable;

public class ItemBuilder {
    private final ItemConfig config;
    private LocalizationProvider localization;
    private final List<Placeholder<?>> placeholders = new ArrayList();
    private Supplier<List<Component>> loreBuilder = null;
    private final Collection<PotionEffect> potionEffects = new ArrayList<PotionEffect>();
    private Color potionColor = null;
    private ItemStack item = null;
    private final List<String> extraLore = new ArrayList<String>();
    private PlayerProfile playerProfile;
    private static final Map<String, String> skinCache = new HashMap<String, String>();
    private static final Map<String, com.destroystokyo.paper.profile.PlayerProfile> profileCache = new HashMap<String, com.destroystokyo.paper.profile.PlayerProfile>();

    private ItemBuilder(ItemConfig config) {
        this.config = new ItemConfig(config);
    }

    private ItemBuilder(ItemConfig config, ItemStack item) {
        this.config = new ItemConfig(config);
        this.item = item.clone();
    }

    public static ItemBuilder of(ItemConfig config) {
        return new ItemBuilder(config);
    }

    public static ItemBuilder close(ItemConfig config) {
        return new ItemBuilder(config).defaultMaterial(Material.BARRIER).defaultSlot(53);
    }

    public static ItemBuilder back(ItemConfig config) {
        return new ItemBuilder(config).defaultMaterial(Material.ARROW).defaultSlot(45);
    }

    public static ItemBuilder item(ItemStack item) {
        return new ItemBuilder(new ItemConfig(), item);
    }

    public static ItemStack filler(Material material, String name) {
        if (material == Material.AIR) {
            return new ItemStack(Material.AIR);
        }
        ItemStack item = new ItemStack(material);
        ItemMeta meta = item.getItemMeta();
        meta.displayName(Text.component(name, new Placeholder[0]));
        item.setItemMeta(meta);
        return item;
    }

    public static ItemStack filler(Material material) {
        return ItemBuilder.filler(material, " ");
    }

    public static ItemStack filler() {
        return ItemBuilder.filler(Material.BLACK_STAINED_GLASS_PANE);
    }

    public static ItemStack fromType(TypeId typeId, @Nullable Player player) {
        return Aurora.getExpansionManager().getExpansion(ItemExpansion.class).getItemManager().resolveItem(typeId, player);
    }

    public ItemBuilder localization(LocalizationProvider localization) {
        this.localization = localization;
        return this;
    }

    public ItemBuilder enableRefreshing() {
        this.config.setRefresh(true);
        return this;
    }

    public ItemBuilder disableRefreshing() {
        this.config.setRefresh(false);
        return this;
    }

    public ItemBuilder defaultMaterial(Material material) {
        if (this.config.getMaterial() == null) {
            this.config.setMaterial(material.name());
        }
        return this;
    }

    public ItemBuilder potionColor(Color color) {
        this.potionColor = color;
        return this;
    }

    public ItemBuilder addPotionEffect(PotionEffect effect) {
        this.potionEffects.add(effect);
        return this;
    }

    public ItemBuilder potionEffect(Collection<PotionEffect> effects) {
        this.potionEffects.addAll(effects);
        return this;
    }

    public ItemBuilder extraLore(String lore) {
        this.extraLore.add(lore);
        return this;
    }

    public ItemBuilder extraLore(List<String> lore) {
        this.extraLore.addAll(lore);
        return this;
    }

    public ItemBuilder material(Material material) {
        this.config.setMaterial(material.name());
        return this;
    }

    public ItemBuilder defaultAmount(int amount) {
        if (this.config.getAmount() == null) {
            this.config.setAmount(amount);
        }
        return this;
    }

    public ItemBuilder amount(int amount) {
        this.config.setAmount(amount);
        return this;
    }

    public ItemBuilder setName(String name) {
        this.config.setName(name);
        return this;
    }

    public ItemBuilder setLore(List<String> lore) {
        this.config.setLore(lore);
        return this;
    }

    public ItemBuilder loreCompute(Supplier<List<Component>> builder) {
        this.loreBuilder = builder;
        return this;
    }

    public ItemBuilder defaultSlot(int slot) {
        if (!(this.config.getSlot() != null && this.config.getSlot() >= 0 || this.config.getSlots() != null && !this.config.getSlots().isEmpty())) {
            this.config.setSlot(slot);
        }
        return this;
    }

    public ItemBuilder slot(int slot) {
        this.config.setSlot(slot);
        return this;
    }

    public ItemBuilder flag(ItemFlag flag) {
        this.config.getFlags().add(flag.name());
        return this;
    }

    public ItemBuilder flag(ItemFlag ... flags) {
        for (ItemFlag flag : flags) {
            this.config.getFlags().add(flag.name());
        }
        return this;
    }

    public ItemBuilder flag(String flag) {
        this.config.getFlags().add(flag);
        return this;
    }

    public ItemBuilder flag(String ... flags) {
        for (String flag : flags) {
            this.config.getFlags().add(flag);
        }
        return this;
    }

    public ItemBuilder setPlayerHead(Player player) {
        this.config.setMaterial(Material.PLAYER_HEAD.name());
        this.playerProfile = player.getPlayerProfile();
        return this;
    }

    public ItemBuilder skullUrl(String url) {
        this.config.setMaterial(Material.PLAYER_HEAD.name());
        if (this.config.getSkull() == null) {
            this.config.setSkull(new SkullConfig());
        }
        this.config.getSkull().setUrl(url);
        return this;
    }

    public ItemBuilder skullBase64(String base64) {
        this.config.setMaterial(Material.PLAYER_HEAD.name());
        if (this.config.getSkull() == null) {
            this.config.setSkull(new SkullConfig());
        }
        this.config.getSkull().setBase64(base64);
        return this;
    }

    public ItemBuilder placeholder(Placeholder<?> placeholder) {
        this.placeholders.add(placeholder);
        return this;
    }

    public ItemBuilder placeholder(List<Placeholder<?>> placeholders) {
        this.placeholders.addAll(placeholders);
        return this;
    }

    public MenuItem build(Player player) {
        if (this.item == null) {
            return new MenuItem(player, this, this.toItemStack(player));
        }
        return new MenuItem(player, this, this.toItemStack(this.item, player));
    }

    public ItemStack toItemStack(Player player) {
        ItemStack item;
        if (this.config.getMaterial().contains(":")) {
            item = ItemBuilder.fromType(TypeId.fromDefault(this.config.getMaterial()), player);
        } else if (this.config.getMaterial().equalsIgnoreCase("self_head")) {
            this.setPlayerHead(player);
            item = new ItemStack(Material.PLAYER_HEAD);
        } else {
            item = this.config.getMaterial().equalsIgnoreCase("main_hand") ? player.getInventory().getItemInMainHand().clone() : new ItemStack(Material.valueOf((String)this.config.getMaterial().toUpperCase(Locale.ROOT)));
        }
        if (item.getType() == Material.AIR) {
            return item;
        }
        return this.toItemStack(item, player);
    }

    /*
     * WARNING - void declaration
     */
    public ItemStack toItemStack(ItemStack item, Player player) {
        List<Component> lore;
        LocalizationProvider lang = this.localization == null ? Aurora.getLocalizationProvider() : this.localization;
        item.setAmount(Math.max(this.config.getAmount(), 1));
        ItemMeta meta = item.getItemMeta();
        if (Version.isAtLeastVersion(20, 5) && this.config.getHideTooltip() != null && this.config.getHideTooltip().booleanValue()) {
            meta.setHideTooltip(true);
        }
        if (Version.isAtLeastVersion(21, 2) && this.config.getTooltipStyle() != null) {
            meta.setTooltipStyle(NamespacedKey.fromString((String)this.config.getTooltipStyle()));
        }
        if (this.config.getName() != null) {
            meta.displayName(Text.component(player, lang.fillVariables(player, this.config.getName(), this.placeholders), new Placeholder[0]));
        }
        if (!this.config.getLore().isEmpty()) {
            lore = new ArrayList();
            for (String line : this.config.getLore()) {
                ((ArrayList)lore).addAll(this.wrapLoreLine(player, line, lang));
            }
            meta.lore(lore);
        }
        if (this.loreBuilder != null) {
            meta.lore(this.loreBuilder.get());
        }
        if (this.config.getAppendLore() != null && !this.config.getAppendLore().isEmpty()) {
            lore = meta.lore();
            if (lore == null) {
                lore = new ArrayList();
            }
            for (String line : this.config.getAppendLore()) {
                lore.addAll(this.wrapLoreLine(player, line, lang));
            }
            meta.lore(lore);
        }
        if (this.config.getConditionalLore() != null && !this.config.getConditionalLore().isEmpty()) {
            lore = meta.lore();
            if (lore == null) {
                lore = new ArrayList();
            }
            for (ItemConfig.ConditionalLore conditional : this.config.getConditionalLore()) {
                if (!Requirement.isAllMet(player, conditional.getConditions(), this.placeholders)) continue;
                for (String line : conditional.getLore()) {
                    lore.addAll(this.wrapLoreLine(player, line, lang));
                }
            }
            meta.lore(lore);
        }
        if (!this.extraLore.isEmpty()) {
            lore = meta.lore();
            if (lore == null) {
                lore = new ArrayList();
            }
            lore.addAll(this.extraLore.stream().map(l -> Text.component(player, lang.fillVariables(player, (String)l, this.placeholders), new Placeholder[0])).toList());
            meta.lore(lore);
        }
        if (this.config.getDurability() != null && meta instanceof Damageable) {
            Damageable damageable = (Damageable)meta;
            damageable.setDamage(this.config.getDurability().intValue());
        }
        if (this.config.getCustomModelData() != null) {
            meta.setCustomModelData(this.config.getCustomModelData());
        }
        if (Version.isAtLeastVersion(21, 4) && this.config.getItemModel() != null) {
            meta.setItemModel(NamespacedKey.fromString((String)this.config.getItemModel()));
        }
        for (Map.Entry entry : this.config.getEnchantments().entrySet()) {
            Enchantment enchantment;
            NamespacedKey key = NamespacedKey.fromString((String)((String)entry.getKey()));
            if (key == null || (enchantment = (Enchantment)Registry.ENCHANTMENT.get(key)) == null) continue;
            meta.addEnchant(enchantment, ((Integer)entry.getValue()).intValue(), true);
        }
        if (this.config.getFlags() != null) {
            for (String string : this.config.getFlags()) {
                ItemFlag pFlag = ItemFlag.valueOf((String)string.toUpperCase(Locale.ROOT));
                if (pFlag == ItemFlag.HIDE_ATTRIBUTES && Version.isAtLeastVersion(20, 5)) {
                    meta.setAttributeModifiers((Multimap)HashMultimap.create());
                }
                meta.addItemFlags(new ItemFlag[]{pFlag});
            }
        }
        if (meta instanceof SkullMeta) {
            void var6_18;
            SkullMeta skullMeta = (SkullMeta)meta;
            String string = this.config.getTexture();
            if (this.config.getSkull() != null) {
                if (this.config.getSkull().getUrl() != null) {
                    String string2 = this.config.getSkull().getUrl();
                } else if (this.config.getSkull().getBase64() != null) {
                    String string3 = ItemBuilder.decodeSkinUrl(this.config.getSkull().getBase64());
                }
            }
            if (var6_18 != null) {
                if (profileCache.containsKey(var6_18)) {
                    skullMeta.setPlayerProfile(profileCache.get(var6_18));
                } else {
                    com.destroystokyo.paper.profile.PlayerProfile profile = Bukkit.createProfile((UUID)UUID.randomUUID());
                    try {
                        PlayerTextures textures = profile.getTextures();
                        textures.setSkin(URI.create((String)var6_18).toURL());
                        profile.setTextures(textures);
                        skullMeta.setPlayerProfile(profile);
                        profileCache.put((String)var6_18, profile);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            if (this.playerProfile != null) {
                skullMeta.setOwnerProfile(this.playerProfile);
            }
        }
        if (meta instanceof PotionMeta) {
            PotionMeta potionMeta = (PotionMeta)meta;
            if (this.config.getPotion() != null) {
                BukkitPotionType bukkitPotionType = new BukkitPotionType(PotionType.valueOf((String)this.config.getPotion().getType().toUpperCase(Locale.ROOT)), this.config.getPotion().getExtended(), this.config.getPotion().getUpgraded());
                bukkitPotionType.applyToMeta(potionMeta);
            }
            if (!this.potionEffects.isEmpty()) {
                potionMeta.clearCustomEffects();
                for (PotionEffect effect : this.potionEffects) {
                    potionMeta.addCustomEffect(effect, true);
                }
            }
            if (this.potionColor != null) {
                potionMeta.setColor(this.potionColor);
            }
        }
        item.setItemMeta(meta);
        return item;
    }

    public static String decodeSkinUrl(String base64Texture) {
        if (skinCache.containsKey(base64Texture)) {
            return skinCache.get(base64Texture);
        }
        String decoded = new String(Base64.getDecoder().decode(base64Texture));
        JsonObject object = JsonParser.parseString((String)decoded).getAsJsonObject();
        JsonElement textures = object.get("textures");
        if (textures == null) {
            return null;
        }
        JsonElement skin = textures.getAsJsonObject().get("SKIN");
        if (skin == null) {
            return null;
        }
        JsonElement url = skin.getAsJsonObject().get("url");
        if (url != null) {
            skinCache.put(base64Texture, url.getAsString());
            return url.getAsString();
        }
        return null;
    }

    private List<Component> wrapLoreLine(Player player, String line, LocalizationProvider lang) {
        ArrayList<Component> lore = new ArrayList<Component>();
        if (line.startsWith("[wrap:")) {
            int endIndex = line.indexOf("]");
            int length = Integer.parseInt(line.substring("[wrap:".length(), endIndex));
            lore.addAll(ComponentWrapper.wrap(Text.component(player, lang.fillVariables(player, line.substring(endIndex + 1), this.placeholders), new Placeholder[0]), length));
        } else {
            lore.add(Text.component(player, lang.fillVariables(player, line, this.placeholders), new Placeholder[0]));
        }
        return lore;
    }

    public ItemConfig getConfig() {
        return this.config;
    }

    public List<Placeholder<?>> getPlaceholders() {
        return this.placeholders;
    }
}

