/*
 * Decompiled with CFR 0.152.
 */
package gg.auroramc.aurora.api.menu;

import gg.auroramc.aurora.api.menu.MenuAction;
import gg.auroramc.aurora.api.menu.MenuItem;
import gg.auroramc.aurora.api.menu.Requirement;
import java.util.function.Consumer;
import java.util.function.Function;
import org.bukkit.event.inventory.InventoryClickEvent;

public class MenuEntry {
    private final MenuItem item;
    private final Consumer<InventoryClickEvent> consumer;
    private final Function<InventoryClickEvent, MenuAction> smartConsumer;
    private boolean active = false;

    public MenuEntry(MenuItem item, Function<InventoryClickEvent, MenuAction> smartConsumer) {
        this.item = item;
        this.consumer = null;
        this.smartConsumer = smartConsumer;
    }

    public MenuEntry(MenuItem item, Consumer<InventoryClickEvent> handler) {
        this.item = item;
        this.consumer = handler;
        this.smartConsumer = null;
    }

    public MenuEntry(MenuItem item) {
        this.item = item;
        this.consumer = null;
        this.smartConsumer = null;
    }

    public int getPriority() {
        return this.item.getItemBuilder().getConfig().getPriority();
    }

    public MenuAction handleEvent(InventoryClickEvent event) {
        if (!Requirement.passes(this.item.getPlayer(), this.item.getItemBuilder().getConfig().getClickRequirements(), this.item.getPlaceholders())) {
            return MenuAction.NONE;
        }
        if (event.isLeftClick() ? !Requirement.passes(this.item.getPlayer(), this.item.getItemBuilder().getConfig().getLeftClickRequirements(), this.item.getPlaceholders()) : event.isRightClick() && !Requirement.passes(this.item.getPlayer(), this.item.getItemBuilder().getConfig().getRightClickRequirements(), this.item.getPlaceholders())) {
            return MenuAction.NONE;
        }
        MenuAction action = MenuAction.NONE;
        if (this.smartConsumer != null) {
            action = this.smartConsumer.apply(event);
        } else if (this.consumer != null) {
            this.consumer.accept(event);
        }
        this.item.runOnClickCommands(this.item.getPlayer());
        if (event.isLeftClick()) {
            this.item.runOnLeftClickCommands(this.item.getPlayer());
        } else if (event.isRightClick()) {
            this.item.runOnRightClickCommands(this.item.getPlayer());
        }
        return action;
    }

    public MenuItem getItem() {
        return this.item;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }
}

