/*
 * Decompiled with CFR 0.152.
 */
package gg.auroramc.aurora.api.menu;

import gg.auroramc.aurora.Aurora;
import gg.auroramc.aurora.api.menu.AuroraMenu;
import io.papermc.paper.threadedregions.scheduler.ScheduledTask;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;

public class MenuRefresher {
    private final Set<AuroraMenu> menus = Collections.newSetFromMap(new ConcurrentHashMap());
    private ScheduledTask refreshTask = null;
    private final Aurora plugin;

    public MenuRefresher(Aurora plugin) {
        this.plugin = plugin;
    }

    public void add(AuroraMenu menu) {
        this.menus.add(menu);
        if (this.refreshTask == null || this.refreshTask.isCancelled()) {
            this.refreshTask = Bukkit.getAsyncScheduler().runAtFixedRate((Plugin)this.plugin, task -> {
                for (AuroraMenu m : this.menus) {
                    m.refresh();
                }
            }, 1L, 1L, TimeUnit.SECONDS);
        }
    }

    public void remove(AuroraMenu menu) {
        this.menus.remove(menu);
        if (this.menus.isEmpty() && this.refreshTask != null) {
            this.refreshTask.cancel();
            this.refreshTask = null;
        }
    }
}

