/*
 * Decompiled with CFR 0.152.
 */
package gg.auroramc.aurora.api.placeholder;

import gg.auroramc.aurora.api.placeholder.PlaceholderHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.entity.Player;

public class PlaceholderHandlerRegistry {
    private static final Map<String, PlaceholderHandler> handlers = new HashMap<String, PlaceholderHandler>();

    public static void addHandler(PlaceholderHandler handler) {
        if (handler == null) {
            return;
        }
        handlers.put(handler.getIdentifier(), handler);
    }

    public static void removeHandler(PlaceholderHandler handler) {
        if (handler == null) {
            return;
        }
        handlers.remove(handler.getIdentifier());
    }

    public static String fillPlaceholderRequest(Player player, String params) {
        String[] splitParams = params.split("_");
        if (splitParams.length == 0) {
            return null;
        }
        String id = splitParams[0];
        PlaceholderHandler handler = handlers.get(id);
        if (handler == null) {
            return null;
        }
        if (player == null && !handler.handleNullPlayer()) {
            return null;
        }
        if (player != null && !player.isOnline()) {
            return null;
        }
        return handler.onPlaceholderRequest(player, Arrays.copyOfRange(splitParams, 1, splitParams.length));
    }

    public static String getGlobalId() {
        return "aurora";
    }

    public static List<String> getPatterns() {
        ArrayList<String> list = new ArrayList<String>();
        for (PlaceholderHandler handler : handlers.values()) {
            if (handler.getPatterns() == null) {
                list.add("%" + PlaceholderHandlerRegistry.getGlobalId() + "_" + handler.getIdentifier() + "%");
                continue;
            }
            list.addAll(handler.getPatterns().stream().map(p -> p.isEmpty() ? "%" + PlaceholderHandlerRegistry.getGlobalId() + "_" + handler.getIdentifier() + "%" : "%" + PlaceholderHandlerRegistry.getGlobalId() + "_" + handler.getIdentifier() + "_" + p + "%").toList());
        }
        return list;
    }
}

