/*
 * Decompiled with CFR 0.152.
 */
package gg.auroramc.aurora.api.user;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import gg.auroramc.aurora.Aurora;
import gg.auroramc.aurora.api.events.user.AuroraUserLoadedEvent;
import gg.auroramc.aurora.api.events.user.AuroraUserUnloadedEvent;
import gg.auroramc.aurora.api.message.Placeholder;
import gg.auroramc.aurora.api.message.Text;
import gg.auroramc.aurora.api.user.AuroraUser;
import gg.auroramc.aurora.api.user.UserDataHolder;
import gg.auroramc.aurora.api.user.migration.StorageMigrator;
import gg.auroramc.aurora.api.user.storage.LatencyMeasure;
import gg.auroramc.aurora.api.user.storage.SaveReason;
import gg.auroramc.aurora.api.user.storage.UserStorage;
import gg.auroramc.aurora.api.user.storage.YamlStorage;
import gg.auroramc.aurora.api.user.storage.sql.MySqlStorage;
import gg.auroramc.aurora.expansions.leaderboard.LeaderboardExpansion;
import gg.auroramc.aurora.expansions.leaderboard.storage.sqlite.SqliteLeaderboardStorage;
import io.papermc.paper.threadedregions.scheduler.ScheduledTask;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerPreLoginEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;

public class UserManager
implements Listener {
    private volatile UserStorage storage;
    private final ConcurrentHashMap<UUID, Object> playerLocks = new ConcurrentHashMap();
    private final Set<Class<? extends UserDataHolder>> dataHolders = new HashSet<Class<? extends UserDataHolder>>();
    private ScheduledTask autoSaveTask;
    private ScheduledTask leaderboardUpdateTask;
    private final LatencyMeasure loadLatencyMeasure = new LatencyMeasure();
    private final LatencyMeasure saveLatencyMeasure = new LatencyMeasure();
    private final LatencyMeasure syncFlagLatencyMeasure = new LatencyMeasure();
    private StorageMigrator migrator = new StorageMigrator(this);
    private final Cache<UUID, AuroraUser> cache = CacheBuilder.newBuilder().build();

    public UserManager() {
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)Aurora.getInstance());
        this.storage = Aurora.getLibConfig().getStorageType().equals("mysql") ? new MySqlStorage() : new YamlStorage();
        this.autoSaveTask();
        this.leaderboardUpdateTask();
    }

    public CompletableFuture<Boolean> attemptMigration(int threadCount) {
        this.migrator.markMigrating();
        return CompletableFuture.supplyAsync(() -> {
            MySqlStorage mySqlStorage;
            this.stopTasksAndSaveAllData(false);
            this.cache.invalidateAll();
            Bukkit.getGlobalRegionScheduler().run((Plugin)Aurora.getInstance(), task -> Bukkit.getOnlinePlayers().forEach(player -> player.kick(Text.component(Aurora.getMsg(player).getKickedByDbMigration(), new Placeholder[0]))));
            UserStorage newStorage = this.storage;
            String newStorageId = this.storage instanceof MySqlStorage ? "yaml" : "mysql";
            boolean success = false;
            UserStorage patt0$temp = this.storage;
            if (patt0$temp instanceof MySqlStorage) {
                mySqlStorage = (MySqlStorage)patt0$temp;
                newStorage = new YamlStorage();
                success = this.migrator.migrateUserData(mySqlStorage, (YamlStorage)newStorage, threadCount);
            } else {
                UserStorage patt1$temp = this.storage;
                if (patt1$temp instanceof YamlStorage) {
                    YamlStorage yamlStorage = (YamlStorage)patt1$temp;
                    newStorage = new MySqlStorage();
                    success = this.migrator.migrateUserData(yamlStorage, (MySqlStorage)newStorage, threadCount);
                }
            }
            if (success) {
                this.storage.dispose();
                this.storage = newStorage;
                if (newStorage instanceof MySqlStorage) {
                    mySqlStorage = (MySqlStorage)newStorage;
                    Aurora.getExpansionManager().getExpansion(LeaderboardExpansion.class).setStorage(mySqlStorage);
                } else {
                    Aurora.getExpansionManager().getExpansion(LeaderboardExpansion.class).setStorage(new SqliteLeaderboardStorage());
                }
                Aurora.getLibConfig().setStorageType(newStorageId);
                Aurora.getLibConfig().saveChanges();
                this.autoSaveTask();
                this.leaderboardUpdateTask();
            }
            this.migrator.markFinished();
            return success;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean saveUserData(AuroraUser user, SaveReason reason) {
        Object object = this.getPlayerLock(user.getUniqueId());
        synchronized (object) {
            boolean result = this.storage.saveUser(user, reason);
            if (reason == SaveReason.QUIT && !Bukkit.isStopping() && !Aurora.isDisabling()) {
                Aurora.logger().debug("Saved user " + String.valueOf(user.getUniqueId()) + " into storage");
                Bukkit.getGlobalRegionScheduler().run((Plugin)Aurora.getInstance(), task -> Bukkit.getPluginManager().callEvent((Event)new AuroraUserUnloadedEvent(user)));
            }
            return result;
        }
    }

    private void autoSaveTask() {
        this.autoSaveTask = Bukkit.getAsyncScheduler().runDelayed((Plugin)Aurora.getInstance(), task -> {
            Collection values = this.cache.asMap().values();
            List<AuroraUser> toSave = values.stream().filter(u -> u.isLoaded() && u.isDirty()).toList();
            if (!toSave.isEmpty()) {
                int successCount = this.storage.bulkSaveUsers(toSave, SaveReason.AUTO_SAVE);
                int all = toSave.size();
                if (!Bukkit.getOnlinePlayers().isEmpty() && !values.isEmpty()) {
                    Aurora.logger().info("Auto background saved user data for " + successCount + "/" + all + " online players");
                }
            }
            this.autoSaveTask();
        }, (long)Aurora.getLibConfig().getUserAutoSaveInMinutes().intValue(), TimeUnit.MINUTES);
    }

    private void leaderboardUpdateTask() {
        this.leaderboardUpdateTask = Bukkit.getAsyncScheduler().runDelayed((Plugin)Aurora.getInstance(), task -> {
            LeaderboardExpansion lbm = Aurora.getExpansionManager().getExpansion(LeaderboardExpansion.class);
            Collection values = this.cache.asMap().values();
            HashMap<UUID, Collection<String>> toUpdate = new HashMap<UUID, Collection<String>>();
            for (AuroraUser user : values) {
                Map<String, Double> dirtyBoards = user.getDirtyLeaderboards();
                if (!user.isLoaded() || dirtyBoards.isEmpty()) continue;
                user.updateOriginalLeaderboardDataFromCurrent();
                toUpdate.put(user.getUniqueId(), dirtyBoards.keySet());
            }
            if (toUpdate.isEmpty()) {
                lbm.updateLeaderBoards();
                this.leaderboardUpdateTask();
                return;
            }
            ((CompletableFuture)lbm.bulkUpdateUsers(toUpdate).thenRunAsync(lbm::updateLeaderBoards)).thenRun(this::leaderboardUpdateTask);
        }, 5L, TimeUnit.MINUTES);
    }

    private Object getPlayerLock(UUID playerId) {
        return this.playerLocks.computeIfAbsent(playerId, k -> new Object());
    }

    public <T extends UserDataHolder> void registerUserDataHolder(Class<T> clazz) {
        this.dataHolders.add(clazz);
    }

    public boolean isUserCached(UUID uuid) {
        return this.cache.getIfPresent((Object)uuid) != null;
    }

    public AuroraUser getUser(OfflinePlayer player) {
        return this.getUser(player.getUniqueId());
    }

    public AuroraUser getUser(Player player) {
        return this.getUser(player.getUniqueId());
    }

    public AuroraUser getUser(UUID uuid) {
        AuroraUser user = (AuroraUser)this.cache.getIfPresent((Object)uuid);
        if (user != null) {
            return user;
        }
        return this.cache.asMap().computeIfAbsent(uuid, key -> {
            AuroraUser fakeUser = new AuroraUser((UUID)key, false);
            fakeUser.initData(null, this.dataHolders);
            Aurora.logger().debug("Created fake user " + String.valueOf(key) + " in cache");
            return fakeUser;
        });
    }

    public void loadUser(UUID uuid) {
        CompletableFuture.runAsync(() -> {
            Object object = this.getPlayerLock(uuid);
            synchronized (object) {
                LeaderboardExpansion lbm = Aurora.getExpansionManager().getExpansion(LeaderboardExpansion.class);
                this.storage.loadUser(uuid, this.dataHolders, user -> {
                    if (Bukkit.getPlayer((UUID)uuid) == null) {
                        return;
                    }
                    AuroraUser maybeUser = (AuroraUser)this.cache.getIfPresent((Object)uuid);
                    if (maybeUser != null && !maybeUser.isLoaded()) {
                        lbm.loadUser(user.getUniqueId()).thenAcceptAsync(maybeUser.getLeaderboardEntries()::putAll);
                        maybeUser.loadFromUser((AuroraUser)user);
                        Aurora.logger().debug("Updated user " + String.valueOf(user.getUniqueId()) + " in cache");
                        Bukkit.getGlobalRegionScheduler().run((Plugin)Aurora.getInstance(), task -> Bukkit.getPluginManager().callEvent((Event)new AuroraUserLoadedEvent((AuroraUser)user)));
                    } else {
                        lbm.loadUser(user.getUniqueId()).thenAcceptAsync(user.getLeaderboardEntries()::putAll);
                        this.cache.put((Object)uuid, user);
                        Aurora.logger().debug("Loaded user " + String.valueOf(user.getUniqueId()) + " into cache");
                        Bukkit.getGlobalRegionScheduler().run((Plugin)Aurora.getInstance(), task -> Bukkit.getPluginManager().callEvent((Event)new AuroraUserLoadedEvent((AuroraUser)user)));
                    }
                });
            }
        });
    }

    public CompletableFuture<AuroraUser> loadUserFromStorage(UUID uuid) {
        return CompletableFuture.supplyAsync(() -> this.storage.loadUser(uuid, this.dataHolders));
    }

    public void purgeUserData(UUID uuid) {
        CompletableFuture.runAsync(() -> {
            Object object = this.getPlayerLock(uuid);
            synchronized (object) {
                if (this.cache.getIfPresent((Object)uuid) != null) {
                    AuroraUser oldUser = (AuroraUser)this.cache.getIfPresent((Object)uuid);
                    this.cache.invalidate((Object)uuid);
                    AuroraUser newUser = new AuroraUser(uuid, true);
                    newUser.initData(new YamlConfiguration(), this.dataHolders);
                    this.cache.put((Object)uuid, (Object)newUser);
                    this.storage.purgeUser(uuid);
                    Bukkit.getGlobalRegionScheduler().run((Plugin)Aurora.getInstance(), task -> {
                        Bukkit.getPluginManager().callEvent((Event)new AuroraUserUnloadedEvent(oldUser));
                        Bukkit.getPluginManager().callEvent((Event)new AuroraUserLoadedEvent(newUser));
                    });
                } else {
                    this.storage.purgeUser(uuid);
                }
            }
        });
    }

    public void stopTasksAndSaveAllData(boolean dispose) {
        if (this.autoSaveTask != null) {
            this.autoSaveTask.cancel();
        }
        if (this.leaderboardUpdateTask != null) {
            this.leaderboardUpdateTask.cancel();
        }
        this.storage.bulkSaveUsers(this.cache.asMap().values().stream().filter(AuroraUser::isLoaded).toList(), SaveReason.QUIT);
        LeaderboardExpansion lbm = Aurora.getExpansionManager().getExpansion(LeaderboardExpansion.class);
        lbm.bulkUpdateUsers(this.cache.asMap().values().stream().filter(AuroraUser::isLoaded).collect(HashMap::new, (m, u) -> m.put(u.getUniqueId(), u.getDirtyLeaderboards().keySet()), HashMap::putAll)).join();
        if (dispose) {
            this.storage.dispose();
        }
    }

    public void invalidate(Player player) {
        AuroraUser user = (AuroraUser)this.cache.getIfPresent((Object)player.getUniqueId());
        if (user == null) {
            return;
        }
        CompletableFuture.supplyAsync(() -> {
            LeaderboardExpansion lbm = Aurora.getExpansionManager().getExpansion(LeaderboardExpansion.class);
            lbm.updateUser(user, Collections.emptyList()).join();
            return this.saveUserData(user, SaveReason.QUIT);
        }).thenAcceptAsync(success -> {
            if (user.getPlayer() == null || !user.getPlayer().isOnline()) {
                Aurora.logger().debug("Removed user " + String.valueOf(user.getUniqueId()) + " from cache");
                this.playerLocks.remove(user.getUniqueId());
                this.cache.invalidate((Object)player.getUniqueId());
            } else {
                Aurora.logger().debug("Failed to remove user " + String.valueOf(user.getUniqueId()) + " from cache, because player is still online");
            }
        });
    }

    @EventHandler(ignoreCancelled=true)
    public void onPlayerJoin(PlayerJoinEvent e) {
        this.loadUser(e.getPlayer().getUniqueId());
    }

    @EventHandler
    public void onPlayerPreJoin(AsyncPlayerPreLoginEvent e) {
        if (this.migrator.isMigrating()) {
            e.kickMessage(Text.component("&cUnder maintenance, please try again later.", new Placeholder[0]));
            e.setLoginResult(AsyncPlayerPreLoginEvent.Result.KICK_OTHER);
        }
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent e) {
        if (this.migrator.isMigrating()) {
            return;
        }
        Bukkit.getGlobalRegionScheduler().runDelayed((Plugin)Aurora.getInstance(), task -> this.invalidate(e.getPlayer()), 1L);
    }

    public UserStorage getStorage() {
        return this.storage;
    }

    public Set<Class<? extends UserDataHolder>> getDataHolders() {
        return this.dataHolders;
    }

    public LatencyMeasure getLoadLatencyMeasure() {
        return this.loadLatencyMeasure;
    }

    public LatencyMeasure getSaveLatencyMeasure() {
        return this.saveLatencyMeasure;
    }

    public LatencyMeasure getSyncFlagLatencyMeasure() {
        return this.syncFlagLatencyMeasure;
    }
}

