/*
 * Decompiled with CFR 0.152.
 */
package gg.auroramc.aurora.api.user;

import com.google.common.collect.Lists;
import gg.auroramc.aurora.api.events.itemstash.StashItemAddEvent;
import gg.auroramc.aurora.api.events.itemstash.StashItemRemoveEvent;
import gg.auroramc.aurora.api.user.UserDataHolder;
import gg.auroramc.aurora.api.util.InventorySerializer;
import gg.auroramc.aurora.api.util.NamespacedId;
import java.util.Arrays;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.Nullable;

public class UserStashHolder
extends UserDataHolder {
    private final List<ItemStack> items = Lists.newCopyOnWriteArrayList();

    @Override
    public NamespacedId getId() {
        return NamespacedId.fromDefault("stash");
    }

    @Override
    public void serializeInto(ConfigurationSection data) {
        data.set("items", (Object)InventorySerializer.serializeItemsAsBase64(this.items));
    }

    @Override
    public void initFrom(@Nullable ConfigurationSection data) {
        if (data == null) {
            return;
        }
        if (data.contains("items")) {
            this.items.addAll(Arrays.stream(InventorySerializer.deserializeItemsFromBase64(data.getString("items"))).toList());
        }
    }

    public boolean addItem(ItemStack item) {
        StashItemAddEvent event = new StashItemAddEvent(this.getUniqueId(), item);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return false;
        }
        for (ItemStack current : this.items) {
            if (!current.isSimilar(item)) continue;
            if (current.getMaxStackSize() >= current.getAmount() + item.getAmount()) {
                current.setAmount(current.getAmount() + item.getAmount());
                this.dirty.set(true);
                return true;
            }
            item.setAmount(item.getAmount() - (current.getMaxStackSize() - current.getAmount()));
            current.setAmount(current.getMaxStackSize());
            if (item.getAmount() != 0) continue;
            this.dirty.set(true);
            return true;
        }
        this.items.add(item);
        this.dirty.set(true);
        return true;
    }

    public boolean removeItem(ItemStack item) {
        int index = -1;
        for (int i = 0; i < this.items.size(); ++i) {
            if (this.items.get(i) != item) continue;
            index = i;
            break;
        }
        if (index == -1) {
            return false;
        }
        StashItemRemoveEvent event = new StashItemRemoveEvent(this.getUniqueId(), item);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return false;
        }
        this.items.remove(index);
        this.dirty.set(true);
        return true;
    }

    public boolean clear() {
        this.items.clear();
        this.dirty.set(true);
        return true;
    }

    public List<ItemStack> getItems() {
        return this.items;
    }
}

