/*
 * Decompiled with CFR 0.152.
 */
package gg.auroramc.aurora.api.util;

import gg.auroramc.aurora.api.util.Version;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.potion.PotionType;

public class BukkitPotionType {
    private final PotionType type;
    private final boolean extended;
    private final boolean upgraded;

    public BukkitPotionType(PotionType type, boolean extended, boolean upgraded) {
        this.type = type;
        this.extended = extended;
        this.upgraded = upgraded;
    }

    public BukkitPotionType(PotionMeta meta) {
        if (Version.isAtLeastVersion(20, 2)) {
            this.type = meta.getBasePotionType();
            this.extended = this.type.getKey().getKey().contains("long_");
            this.upgraded = this.type.getKey().getKey().contains("strong_");
        } else {
            try {
                Object potionData = PotionMeta.class.getDeclaredMethod("getBasePotionData", new Class[0]).invoke((Object)meta, new Object[0]);
                Method getType = potionData.getClass().getDeclaredMethod("getType", new Class[0]);
                Object potionTypeObj = getType.invoke(potionData, new Object[0]);
                this.type = (PotionType)potionTypeObj;
                Method isExtended = potionData.getClass().getDeclaredMethod("isExtended", new Class[0]);
                this.extended = (Boolean)isExtended.invoke(potionData, new Object[0]);
                Method isUpgraded = potionData.getClass().getDeclaredMethod("isUpgraded", new Class[0]);
                this.upgraded = (Boolean)isUpgraded.invoke(potionData, new Object[0]);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void applyToMeta(PotionMeta meta) {
        if (Version.isAtLeastVersion(20, 2)) {
            meta.setBasePotionType(this.type);
        } else {
            try {
                Class<?> potionDataClass = Class.forName("org.bukkit.potion.PotionData");
                Constructor<?> potionDataConstructor = potionDataClass.getDeclaredConstructor(PotionType.class, Boolean.TYPE, Boolean.TYPE);
                Object potionData = potionDataConstructor.newInstance(this.type, this.extended, this.upgraded);
                Method setBasePotionData = PotionMeta.class.getDeclaredMethod("setBasePotionData", potionDataClass);
                setBasePotionData.invoke((Object)meta, potionData);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public PotionType getType() {
        return this.type;
    }

    public boolean isExtended() {
        return this.extended;
    }

    public boolean isUpgraded() {
        return this.upgraded;
    }
}

