/*
 * Decompiled with CFR 0.152.
 */
package gg.auroramc.aurora.commands;

import gg.auroramc.aurora.Aurora;
import gg.auroramc.aurora.api.command.CommandDispatcher;
import gg.auroramc.aurora.api.message.Chat;
import gg.auroramc.aurora.api.message.Placeholder;
import gg.auroramc.aurora.api.message.Text;
import gg.auroramc.aurora.commands.AuroraCommand;
import gg.auroramc.aurora.commands.LanguageCommand;
import gg.auroramc.aurora.config.MessageConfig;
import gg.auroramc.aurora.expansions.gui.GuiExpansion;
import gg.auroramc.aurora.expansions.leaderboard.LeaderboardExpansion;
import gg.auroramc.aurora.libs.acf.MessageKeys;
import gg.auroramc.aurora.libs.acf.MinecraftMessageKeys;
import gg.auroramc.aurora.libs.acf.PaperCommandManager;
import java.util.List;
import java.util.Locale;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class CommandManager {
    private final Aurora plugin;
    private final PaperCommandManager commandManager;
    private final LegacyComponentSerializer serializer = ((LegacyComponentSerializer.Builder)LegacyComponentSerializer.legacyAmpersand().toBuilder()).hexColors().useUnusualXRepeatedCharacterHexFormat().build();
    private boolean hasSetup = false;

    public CommandManager(Aurora plugin) {
        this.plugin = plugin;
        this.commandManager = new PaperCommandManager((Plugin)plugin);
    }

    private void setupCommands() {
        if (!this.hasSetup) {
            this.commandManager.getLocales().setDefaultLocale(Locale.ENGLISH);
            this.commandManager.usePerIssuerLocale(false);
            this.commandManager.getCommandCompletions().registerCompletion("commandActions", c -> CommandDispatcher.getActions().stream().map(a -> "[" + a + "]").toList());
            this.commandManager.getCommandCompletions().registerCompletion("guiIds", c -> Aurora.getExpansionManager().getExpansion(GuiExpansion.class).getGuiIds());
            this.commandManager.getCommandCompletions().registerCompletion("userMetaKeys", c -> Aurora.getUserManager().getUser(c.getContextValue(Player.class)).getMetaData().getMetaKeys());
            this.commandManager.getCommandCompletions().registerCompletion("userMetaNumberKeys", c -> Aurora.getUserManager().getUser(c.getContextValue(Player.class)).getMetaData().getMetaKeys().stream().filter(k -> Aurora.getUserManager().getUser(c.getContextValue(Player.class)).getMetaData().getMeta((String)k) instanceof Number).toList());
            this.commandManager.getCommandCompletions().registerCompletion("leaderboards", c -> Aurora.getExpansionManager().getExpansion(LeaderboardExpansion.class).getBoards());
            this.commandManager.getCommandCompletions().registerCompletion("languages", c -> Aurora.getLanguageProvider().getSupportedLocales().stream().map(Locale::toLanguageTag).toList());
        }
        MessageConfig msg = Aurora.getMessageConfigs().get(Locale.forLanguageTag(Aurora.getLibConfig().getLocale()));
        this.commandManager.getLocales().addMessage(Locale.ENGLISH, MinecraftMessageKeys.NO_PLAYER_FOUND, this.m(msg.getPlayerNotFound()));
        this.commandManager.getLocales().addMessage(Locale.ENGLISH, MinecraftMessageKeys.NO_PLAYER_FOUND_OFFLINE, this.m(msg.getPlayerNotFound()));
        this.commandManager.getLocales().addMessage(Locale.ENGLISH, MinecraftMessageKeys.NO_PLAYER_FOUND_SERVER, this.m(msg.getPlayerNotFound()));
        this.commandManager.getLocales().addMessage(Locale.ENGLISH, MinecraftMessageKeys.IS_NOT_A_VALID_NAME, this.m(msg.getPlayerNotFound()));
        this.commandManager.getLocales().addMessage(Locale.ENGLISH, MessageKeys.COULD_NOT_FIND_PLAYER, this.m(msg.getPlayerNotFound()));
        this.commandManager.getLocales().addMessage(Locale.ENGLISH, MessageKeys.PERMISSION_DENIED, this.m(msg.getNoPermission()));
        this.commandManager.getLocales().addMessage(Locale.ENGLISH, MessageKeys.PERMISSION_DENIED_PARAMETER, this.m(msg.getNoPermission()));
        this.commandManager.getLocales().addMessage(Locale.ENGLISH, MessageKeys.INVALID_SYNTAX, this.m(msg.getInvalidSyntax()));
        this.commandManager.getLocales().addMessage(Locale.ENGLISH, MessageKeys.MUST_BE_A_NUMBER, this.m(msg.getMustBeNumber()));
        this.commandManager.getLocales().addMessage(Locale.ENGLISH, MessageKeys.ERROR_PERFORMING_COMMAND, this.m(msg.getCommandError()));
        this.commandManager.getLocales().addMessage(Locale.ENGLISH, MessageKeys.ERROR_GENERIC_LOGGED, this.m(msg.getCommandError()));
        this.commandManager.getLocales().addMessage(Locale.ENGLISH, MessageKeys.NOT_ALLOWED_ON_CONSOLE, this.m(msg.getPlayerOnlyCommand()));
        this.commandManager.getLocales().addMessage(Locale.ENGLISH, MessageKeys.UNKNOWN_COMMAND, this.m(msg.getUnknownCommand()));
        if (!this.hasSetup) {
            this.commandManager.registerCommand(new AuroraCommand(this.plugin));
            this.commandManager.registerCommand(new LanguageCommand());
            this.hasSetup = true;
        }
    }

    public void reload() {
        this.setupCommands();
    }

    private String a(List<String> aliases) {
        return String.join((CharSequence)"|", aliases);
    }

    private String m(String msg) {
        return this.serializer.serialize(Text.component(Chat.translateToMM(msg), new Placeholder[0]));
    }

    public void unregisterCommands() {
        this.commandManager.unregisterCommands();
    }

    public PaperCommandManager getPaperCommandManager() {
        return this.commandManager;
    }
}

