/*
 * Decompiled with CFR 0.152.
 */
package gg.auroramc.aurora.config;

import com.google.common.collect.Lists;
import gg.auroramc.aurora.Aurora;
import gg.auroramc.aurora.api.config.AuroraConfig;
import gg.auroramc.aurora.config.BlockTrackerConfig;
import gg.auroramc.aurora.config.LeaderboardConfig;
import gg.auroramc.aurora.config.MySqlConfig;
import gg.auroramc.aurora.config.NumberFormatConfig;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.bukkit.configuration.file.YamlConfiguration;

public class Config
extends AuroraConfig {
    private Boolean debug = false;
    private NumberFormatConfig numberFormat;
    private Integer userAutoSaveInMinutes = 30;
    private String storageType = "yaml";
    private BlockTrackerConfig blockTracker;
    private Boolean modernBlockTracker = true;
    private MySqlConfig mysql;
    private LeaderboardConfig leaderboards;
    private String defaultEconomyProvider = "auto-detect";
    private Set<String> itemMatchers = Set.of("CustomFishing", "Eco", "ExecutableItems", "ExecutableBlocks", "HeadDatabase", "ItemsAdder", "MMOItems", "MythicMobs", "Nexo", "Oraxen");
    private ItemIdResolverConfig auroraItems;
    private Map<String, Integer> itemResolverPriorities = new HashMap<String, Integer>(){
        {
            this.put("customfishing", 200);
            this.put("eb", 190);
            this.put("emf", 180);
            this.put("ei", 170);
            this.put("mmoitems", 160);
            this.put("mythicmobs", 150);
            this.put("eco", 140);
            this.put("nexo", 130);
            this.put("oraxen", 120);
            this.put("ia", 110);
            this.put("itemedit", 100);
            this.put("kgenerators", 95);
            this.put("hdb", 90);
            this.put("aurora", 80);
        }
    };
    private List<String> supportedLanguages = Lists.newArrayList((Object[])new String[]{"en"});
    private String locale = "en";
    private Boolean usePerPlayerLocale = false;

    public Config() {
        super(new File(Aurora.getInstance().getDataFolder(), "config.yml"));
    }

    @Override
    protected List<Consumer<YamlConfiguration>> getMigrationSteps() {
        return List.of(yaml -> {
            yaml.set("block-tracker.enabled", (Object)true);
            yaml.set("config-version", (Object)1);
        }, yaml -> {
            yaml.set("number-format.short-number-format.format", (Object)"#,##0.##");
            yaml.set("number-format.short-number-format.suffixes", Map.of("thousand", "K", "million", "M", "billion", "B", "trillion", "T", "quadrillion", "Q"));
            yaml.set("config-version", (Object)2);
        }, yaml -> {
            yaml.set("leaderboards.empty-placeholder", (Object)"---");
            yaml.set("config-version", null);
            yaml.set("config-version", (Object)3);
        }, yaml -> {
            yaml.set("default-economy-provider", (Object)"auto-detect");
            yaml.setComments("default-economy-provider", List.of("Use 'auto-detect' to automatically detect the economy provider. Otherwise use the plugin name you want.", "Supported plugins: Vault, Essentials, CMI, PlayerPoints, CoinsEngine, EcoBits, EliteMobs", "RoyaleEconomy", "RoyaleEconomyBank", "Changing this requires a full restart"));
            yaml.set("config-version", null);
            yaml.set("config-version", (Object)4);
        }, yaml -> {
            yaml.set("item-matchers", List.of("CustomFishing", "Eco", "ExecutableItems", "ExecutableBlocks", "HeadDatabase", "ItemsAdder", "MMOItems", "MythicMobs", "Nexo", "Oraxen"));
            yaml.set("config-version", null);
            yaml.set("config-version", (Object)5);
        }, yaml -> {
            yaml.set("aurora-items.enable-id-resolver", (Object)false);
            yaml.setComments("aurora-items", List.of("Should we try resolve IDs for items registered through /aurora registeritem <id>?", "This is experimental and may not work for every use case.", "Changing these values requires a full restart."));
            yaml.set("config-version", null);
            yaml.set("config-version", (Object)6);
        }, yaml -> {
            ArrayList<String> list = new ArrayList<String>(yaml.getStringList("item-matchers"));
            list.add("ItemEdit");
            yaml.set("item-matchers", list);
            yaml.set("config-version", (Object)7);
        }, yaml -> {
            ArrayList<String> list = new ArrayList<String>(yaml.getStringList("item-matchers"));
            list.add("EvenMoreFish");
            yaml.set("item-matchers", list);
            yaml.set("config-version", (Object)8);
        }, yaml -> {
            yaml.set("item-matchers", List.of("CustomFishing", "Eco", "ExecutableItems", "ExecutableBlocks", "HeadDatabase", "ItemsAdder", "MMOItems", "MythicMobs", "Nexo", "Oraxen", "KGenerators"));
            yaml.set("item-resolver-priorities", (Object)new LinkedHashMap<String, Integer>(){
                {
                    this.put("customfishing", 200);
                    this.put("eb", 190);
                    this.put("emf", 180);
                    this.put("ei", 170);
                    this.put("mmoitems", 160);
                    this.put("mythicmobs", 150);
                    this.put("eco", 140);
                    this.put("nexo", 130);
                    this.put("oraxen", 120);
                    this.put("ia", 110);
                    this.put("itemedit", 100);
                    this.put("kgenerators", 95);
                    this.put("hdb", 90);
                    this.put("aurora", 80);
                }
            });
            yaml.set("config-version", (Object)9);
        }, yaml -> {
            yaml.set("supported-languages", List.of("en"));
            yaml.set("fallback-locale", (Object)"en");
            yaml.set("config-version", null);
            yaml.set("config-version", (Object)10);
        }, yaml -> {
            yaml.set("locale", (Object)yaml.getString("fallback-locale", "en"));
            yaml.set("fallback-locale", null);
            yaml.set("use-per-player-locale", (Object)false);
            yaml.set("config-version", (Object)11);
        });
    }

    public Boolean getDebug() {
        return this.debug;
    }

    public NumberFormatConfig getNumberFormat() {
        return this.numberFormat;
    }

    public Integer getUserAutoSaveInMinutes() {
        return this.userAutoSaveInMinutes;
    }

    public String getStorageType() {
        return this.storageType;
    }

    public BlockTrackerConfig getBlockTracker() {
        return this.blockTracker;
    }

    public Boolean getModernBlockTracker() {
        return this.modernBlockTracker;
    }

    public MySqlConfig getMysql() {
        return this.mysql;
    }

    public LeaderboardConfig getLeaderboards() {
        return this.leaderboards;
    }

    public String getDefaultEconomyProvider() {
        return this.defaultEconomyProvider;
    }

    public Set<String> getItemMatchers() {
        return this.itemMatchers;
    }

    public ItemIdResolverConfig getAuroraItems() {
        return this.auroraItems;
    }

    public Map<String, Integer> getItemResolverPriorities() {
        return this.itemResolverPriorities;
    }

    public List<String> getSupportedLanguages() {
        return this.supportedLanguages;
    }

    public String getLocale() {
        return this.locale;
    }

    public Boolean getUsePerPlayerLocale() {
        return this.usePerPlayerLocale;
    }

    public void setStorageType(String storageType) {
        this.storageType = storageType;
    }

    public static final class ItemIdResolverConfig {
        private Boolean enableIdResolver = false;
        private Boolean requireExactMatch = false;
        private Map<String, Boolean> hashIncludes;

        public Boolean getEnableIdResolver() {
            return this.enableIdResolver;
        }

        public Boolean getRequireExactMatch() {
            return this.requireExactMatch;
        }

        public Map<String, Boolean> getHashIncludes() {
            return this.hashIncludes;
        }
    }
}

