/*
 * Decompiled with CFR 0.152.
 */
package gg.auroramc.aurora.expansions.economy.providers;

import com.willfp.ecobits.currencies.Currencies;
import com.willfp.ecobits.currencies.Currency;
import com.willfp.ecobits.currencies.CurrencyUtils;
import gg.auroramc.aurora.api.util.ThreadSafety;
import gg.auroramc.aurora.expansions.economy.AuroraEconomy;
import java.math.BigDecimal;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;

public class EcoBitsEconomy
implements AuroraEconomy {
    private Currency getCurrency(String currency) {
        if (currency == null || Currencies.getByID((String)currency) == null) {
            return (Currency)Currencies.values().getFirst();
        }
        return Currencies.getByID((String)currency);
    }

    @Override
    public void withdraw(Player player, String currency, double amount) {
        CurrencyUtils.adjustBalance((OfflinePlayer)player, (Currency)this.getCurrency(currency), (BigDecimal)BigDecimal.valueOf(-amount));
    }

    @Override
    public void deposit(Player player, String currency, double amount) {
        CurrencyUtils.adjustBalance((OfflinePlayer)player, (Currency)this.getCurrency(currency), (BigDecimal)BigDecimal.valueOf(amount));
    }

    @Override
    public double getBalance(Player player, String currency) {
        return CurrencyUtils.getBalance((OfflinePlayer)player, (Currency)this.getCurrency(currency)).doubleValue();
    }

    @Override
    public boolean hasBalance(Player player, String currency, double amount) {
        return this.getBalance(player, currency) >= amount;
    }

    @Override
    public boolean validateCurrency(String currency) {
        return Currencies.getByID((String)currency) != null;
    }

    @Override
    public boolean supportsCurrency() {
        return true;
    }

    @Override
    public ThreadSafety getThreadSafety() {
        return ThreadSafety.SYNC_ONLY;
    }
}

