/*
 * Decompiled with CFR 0.152.
 */
package gg.auroramc.aurora.expansions.gui;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import gg.auroramc.aurora.Aurora;
import gg.auroramc.aurora.api.command.CommandDispatcher;
import gg.auroramc.aurora.api.menu.AuroraMenu;
import gg.auroramc.aurora.api.menu.ItemBuilder;
import gg.auroramc.aurora.api.menu.MenuAction;
import gg.auroramc.aurora.api.menu.Requirement;
import gg.auroramc.aurora.api.message.Placeholder;
import gg.auroramc.aurora.api.util.NamespacedId;
import gg.auroramc.aurora.expansions.gui.AuroraGui;
import gg.auroramc.aurora.expansions.gui.GuiConfig;
import gg.auroramc.aurora.expansions.gui.GuiOpenCommand;
import io.papermc.paper.threadedregions.scheduler.ScheduledTask;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.Nullable;

public class Gui
implements AuroraGui {
    private Map<String, Command> commands = Maps.newConcurrentMap();
    private final GuiConfig config;
    private final Set<AuroraMenu> menus = Sets.newConcurrentHashSet();
    private ScheduledTask refreshTask = null;
    private final String id;

    public Gui(GuiConfig config, String id) {
        this.config = config;
        this.id = id;
        if (config.getRegisterCommands() != null && !config.getRegisterCommands().isEmpty()) {
            for (String cmd : config.getRegisterCommands()) {
                GuiOpenCommand command = new GuiOpenCommand(cmd, this);
                this.commands.put(cmd, command);
                Aurora.getInstance().getServer().getCommandMap().register("aurora", (Command)command);
            }
        }
        if (config.isRefresh()) {
            this.refreshTask = Bukkit.getAsyncScheduler().runAtFixedRate((Plugin)Aurora.getInstance(), task -> {
                for (AuroraMenu m : this.menus) {
                    m.refresh();
                }
            }, (long)config.getRefreshInterval().intValue(), (long)config.getRefreshInterval().intValue(), TimeUnit.SECONDS);
        }
    }

    public void refreshForPlayer(UUID uuid) {
        for (AuroraMenu menu : this.menus) {
            if (!menu.getPlayer().getUniqueId().equals(uuid)) continue;
            menu.refresh();
        }
    }

    @Override
    public void dispose() {
        if (!this.commands.isEmpty()) {
            for (Map.Entry entry : this.commands.entrySet()) {
                ((Command)entry.getValue()).unregister(Aurora.getInstance().getServer().getCommandMap());
                Aurora.getInstance().getServer().getCommandMap().getKnownCommands().remove(entry.getKey());
            }
        }
        if (this.refreshTask != null && !this.refreshTask.isCancelled()) {
            this.refreshTask.cancel();
        }
        for (AuroraMenu auroraMenu : this.menus) {
            auroraMenu.getPlayer().closeInventory();
        }
    }

    @Override
    public void open(Player player, @Nullable Map<String, String> args) {
        args = args == null ? Map.of() : args;
        ArrayList placeholders = new ArrayList(args.size() + 1);
        args.forEach((key, value) -> placeholders.add(Placeholder.of("{arg_" + key + "}", value)));
        placeholders.add(Placeholder.of("{player}", player.getName()));
        if (this.config.getOpenRequirements() != null && !Requirement.passes(player, this.config.getOpenRequirements(), placeholders)) {
            return;
        }
        AuroraMenu menu = new AuroraMenu(player, this.config.getTitle(), this.config.getRows() * 9, false, NamespacedId.fromDefault(this.id), Aurora.getLocalizationProvider(), (Placeholder[])placeholders.toArray(Placeholder[]::new));
        if (this.config.getFiller() != null) {
            menu.addFiller(ItemBuilder.of(this.config.getFiller()).toItemStack(player));
        } else {
            menu.addFiller(ItemBuilder.filler(Material.AIR));
        }
        this.config.getItems().forEach((id, itemConfig) -> menu.addItem(ItemBuilder.of(itemConfig).placeholder(placeholders).build(player), e -> {
            if (itemConfig.getOnClick() != null && !itemConfig.getOnClick().isEmpty() && !itemConfig.getOnClick().contains("[close]")) {
                return MenuAction.REFRESH_MENU_DELAYED;
            }
            if (e.isLeftClick() && itemConfig.getOnLeftClick() != null && !itemConfig.getOnLeftClick().isEmpty() && !itemConfig.getOnLeftClick().contains("[close]")) {
                return MenuAction.REFRESH_MENU_DELAYED;
            }
            if (e.isRightClick() && itemConfig.getOnRightClick() != null && !itemConfig.getOnRightClick().isEmpty() && !itemConfig.getOnRightClick().contains("[close]")) {
                return MenuAction.REFRESH_MENU_DELAYED;
            }
            return MenuAction.NONE;
        }));
        if (this.config.getCloseActions() != null) {
            menu.onClose((m, e) -> {
                this.menus.remove(m);
                for (String cmd : this.config.getCloseActions()) {
                    CommandDispatcher.dispatch(player, cmd, Placeholder.of("{player}", player.getName()));
                }
            });
        }
        player.getScheduler().run((Plugin)Aurora.getInstance(), task -> {
            menu.open(player, false, this.menus::add);
            if (this.config.getOpenActions() != null) {
                for (String cmd : this.config.getOpenActions()) {
                    CommandDispatcher.dispatch(player, cmd, Placeholder.of("{player}", player.getName()));
                }
            }
        }, null);
    }
}

