/*
 * Decompiled with CFR 0.152.
 */
package gg.auroramc.aurora.expansions.item.resolvers;

import com.willfp.eco.core.items.Items;
import gg.auroramc.aurora.Aurora;
import gg.auroramc.aurora.api.item.ItemResolver;
import gg.auroramc.aurora.api.item.TypeId;
import java.util.Locale;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Player;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.jetbrains.annotations.Nullable;

public class EcoItemsResolver
implements ItemResolver {
    private final NamespacedKey ecoitemsKey = new NamespacedKey("ecoitems", "item");
    private final NamespacedKey ecoarmorKey = new NamespacedKey("ecoarmor", "set");
    private final NamespacedKey ecoarmorAdvancedKey = new NamespacedKey("ecoarmor", "advanced");
    private final NamespacedKey ecoarmorShardKey = new NamespacedKey("ecoarmor", "advancement-shard");
    private final NamespacedKey ecoarmorUpgradeCrystalKey = new NamespacedKey("ecoarmor", "upgrade_crystal");
    private final NamespacedKey talismansKey = new NamespacedKey("talismans", "talisman");
    private final NamespacedKey ecopetsKey = new NamespacedKey("ecopets", "pet_egg");
    private final NamespacedKey reforgesKey = new NamespacedKey("reforges", "reforge_stone");
    private final NamespacedKey ecoscrollsKey = new NamespacedKey("ecoscrolls", "scroll");
    private final NamespacedKey ecocratesKey = new NamespacedKey("ecocrates", "key");
    private final NamespacedKey stattrackersKey = new NamespacedKey("stattrackers", "stat_tracker");

    @Override
    public boolean matches(ItemStack item) {
        if (!item.hasItemMeta()) {
            return false;
        }
        return this.isEcoItem(item.getItemMeta());
    }

    @Override
    public TypeId resolveId(ItemStack item) {
        return this.resolveEcoItemId(item, item.getItemMeta());
    }

    @Override
    public TypeId oneStepMatch(ItemStack item) {
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return null;
        }
        if (this.isEcoItem(meta)) {
            return this.resolveEcoItemId(item, meta);
        }
        return null;
    }

    @Override
    public ItemStack resolveItem(String id, @Nullable Player player) {
        return Items.lookup((String)id).getItem();
    }

    private boolean isEcoItem(ItemMeta item) {
        PersistentDataContainer pdc = item.getPersistentDataContainer();
        return pdc.has(this.ecoitemsKey) || pdc.has(this.ecoarmorKey) || pdc.has(this.talismansKey) || pdc.has(this.ecopetsKey) || pdc.has(this.reforgesKey) || pdc.has(this.ecoscrollsKey) || pdc.has(this.ecocratesKey) || pdc.has(this.ecoarmorShardKey) || pdc.has(this.ecoarmorUpgradeCrystalKey) || pdc.has(this.stattrackersKey);
    }

    private TypeId resolveEcoItemId(ItemStack item, ItemMeta meta) {
        PersistentDataContainer pdc = meta.getPersistentDataContainer();
        PersistentDataType type = PersistentDataType.STRING;
        if (pdc.has(this.ecoitemsKey)) {
            return new TypeId("eco", "ecoitems:" + (String)pdc.get(this.ecoitemsKey, type));
        }
        if (pdc.has(this.ecoarmorKey)) {
            String slot = this.parseArmorSlot(item);
            if (pdc.has(this.ecoarmorAdvancedKey) && (Integer)pdc.get(this.ecoarmorAdvancedKey, PersistentDataType.INTEGER) != 0) {
                return new TypeId("eco", "ecoarmor:set_" + (String)pdc.get(this.ecoarmorKey, type) + "_" + slot + "_advanced");
            }
            return new TypeId("eco", "ecoarmor:set_" + (String)pdc.get(this.ecoarmorKey, type) + "_" + slot);
        }
        if (pdc.has(this.talismansKey)) {
            return new TypeId("eco", "talismans:" + (String)pdc.get(this.talismansKey, type));
        }
        if (pdc.has(this.ecopetsKey)) {
            return new TypeId("eco", "ecopets:" + (String)pdc.get(this.ecopetsKey, type) + "_spawn_egg");
        }
        if (pdc.has(this.reforgesKey)) {
            return new TypeId("eco", "reforges:stone_" + (String)pdc.get(this.reforgesKey, type));
        }
        if (pdc.has(this.ecoscrollsKey)) {
            return new TypeId("eco", "ecoscrolls:scroll_" + (String)pdc.get(this.ecoscrollsKey, type));
        }
        if (pdc.has(this.ecocratesKey)) {
            return new TypeId("eco", "ecocrates:" + (String)pdc.get(this.ecocratesKey, type) + "_key");
        }
        if (pdc.has(this.ecoarmorShardKey)) {
            return new TypeId("eco", "ecoarmor:shard_" + (String)pdc.get(this.ecoarmorShardKey, type));
        }
        if (pdc.has(this.ecoarmorUpgradeCrystalKey)) {
            return new TypeId("eco", "ecoarmor:upgrade_crystal_" + (String)pdc.get(this.ecoarmorUpgradeCrystalKey, type));
        }
        if (pdc.has(this.stattrackersKey)) {
            return new TypeId("eco", "stattrackers:" + (String)pdc.get(this.stattrackersKey, type));
        }
        return null;
    }

    private String parseArmorSlot(ItemStack item) {
        ArmorSlot slot = ArmorSlot.getSlot(item);
        if (slot == null) {
            return "invalid";
        }
        return slot.name().toLowerCase(Locale.getDefault());
    }

    public static enum ArmorSlot {
        HELMET(EquipmentSlot.HEAD),
        CHESTPLATE(EquipmentSlot.CHEST),
        ELYTRA(EquipmentSlot.CHEST),
        LEGGINGS(EquipmentSlot.LEGS),
        BOOTS(EquipmentSlot.FEET);

        private final EquipmentSlot slot;

        private ArmorSlot(EquipmentSlot slot) {
            this.slot = slot;
        }

        public EquipmentSlot getSlot() {
            return this.slot;
        }

        public static ArmorSlot getSlot(ItemStack itemStack) {
            if (itemStack == null) {
                Aurora.logger().severe("Failed to parse armor slot for null item, returning null.");
                return null;
            }
            String materialName = itemStack.getType().name();
            return ArmorSlot.getSlot(materialName);
        }

        public static ArmorSlot getSlot(String name) {
            if (name.contains("HELMET") || name.contains("HEAD") || name.contains("SKULL") || name.contains("PUMPKIN")) {
                return HELMET;
            }
            if (name.contains("CHESTPLATE")) {
                return CHESTPLATE;
            }
            if (name.contains("ELYTRA")) {
                return ELYTRA;
            }
            if (name.contains("LEGGINGS")) {
                return LEGGINGS;
            }
            if (name.contains("BOOTS")) {
                return BOOTS;
            }
            Aurora.logger().severe("Failed to parse armor slot for item type: " + name);
            return null;
        }
    }
}

