/*
 * Decompiled with CFR 0.152.
 */
package gg.auroramc.aurora.expansions.item.store;

import com.google.common.collect.Maps;
import gg.auroramc.aurora.Aurora;
import gg.auroramc.aurora.api.util.InventorySerializer;
import java.io.File;
import java.util.Map;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.inventory.ItemStack;

public class ItemStore {
    private final File file;
    private final YamlConfiguration data;
    private final Map<String, ItemStack> items = Maps.newConcurrentMap();
    private final Map<Integer, String> hashToIdMap = Maps.newHashMap();

    public ItemStore(String filename) {
        this.file = new File(Aurora.getInstance().getDataFolder(), filename);
        if (!this.file.exists()) {
            this.file.createNewFile();
        }
        this.data = YamlConfiguration.loadConfiguration((File)this.file);
        for (String key : this.data.getKeys(false)) {
            ItemStack item = InventorySerializer.readItemStackFromBase64(this.data.getString(key));
            this.items.put(key, item);
            this.hashToIdMap.put(this.generateHash(item), key);
        }
    }

    public void addItem(String id, ItemStack item) {
        this.items.put(id, item.clone());
        this.data.set(id, (Object)InventorySerializer.writeItemStackToBase64(item));
        this.hashToIdMap.put(this.generateHash(item), id);
    }

    public ItemStack getItem(String id) {
        ItemStack item = this.items.get(id);
        return item != null ? item.clone() : null;
    }

    public String getIdFromItem(ItemStack item) {
        return this.hashToIdMap.get(this.generateHash(item));
    }

    public void removeItem(String id) {
        ItemStack item = this.items.remove(id);
        this.hashToIdMap.remove(this.generateHash(item));
        this.data.set(id, null);
    }

    public void saveItems() {
        this.data.save(this.file);
    }

    private int generateHash(ItemStack item) {
        if (item.getAmount() == 1) {
            return item.hashCode();
        }
        ItemStack clonedItem = item.clone();
        clonedItem.setAmount(1);
        return clonedItem.hashCode();
    }
}

