/*
 * Decompiled with CFR 0.152.
 */
package gg.auroramc.aurora.expansions.itemstash;

import com.google.common.collect.Maps;
import gg.auroramc.aurora.Aurora;
import gg.auroramc.aurora.api.events.itemstash.StashItemAddEvent;
import gg.auroramc.aurora.api.events.user.AuroraUserLoadedEvent;
import gg.auroramc.aurora.api.expansions.AuroraExpansion;
import gg.auroramc.aurora.api.message.Chat;
import gg.auroramc.aurora.api.message.Placeholder;
import gg.auroramc.aurora.api.user.AuroraUser;
import gg.auroramc.aurora.config.MessageConfig;
import gg.auroramc.aurora.expansions.itemstash.Config;
import gg.auroramc.aurora.expansions.itemstash.StashCommand;
import gg.auroramc.aurora.expansions.itemstash.StashMenu;
import gg.auroramc.aurora.libs.acf.PaperCommandManager;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public class ItemStashExpansion
implements AuroraExpansion,
Listener {
    private Config config;
    private Map<UUID, StashMenu> menus = Maps.newConcurrentMap();

    @Override
    public void hook() {
        this.reload();
        PaperCommandManager cm = Aurora.getInstance().getCommandManager().getPaperCommandManager();
        cm.getCommandReplacements().addReplacement("stashAlias", this.a(this.config.getCommandAliases()));
        cm.registerCommand(new StashCommand(this));
    }

    @Override
    public boolean canHook() {
        return true;
    }

    @Override
    public void reload() {
        Config.saveDefault();
        this.config = new Config();
        this.config.load();
    }

    public void open(Player player) {
        if (this.menus.containsKey(player.getUniqueId())) {
            return;
        }
        this.menus.put(player.getUniqueId(), new StashMenu(player, this.config, p -> this.menus.remove(p.getUniqueId())));
    }

    public void open(Player player, Player target) {
        if (this.menus.containsKey(target.getUniqueId())) {
            target.closeInventory();
        }
        player.getScheduler().run((Plugin)Aurora.getInstance(), t -> this.menus.put(target.getUniqueId(), new StashMenu(player, target, this.config, p -> this.menus.remove(p.getUniqueId()))), null);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onStashItemAdd(StashItemAddEvent event) {
        if (this.menus.containsKey(event.getPlayerUniqueId())) {
            this.menus.get(event.getPlayerUniqueId()).refresh(this.config);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onUserLoaded(AuroraUserLoadedEvent event) {
        MessageConfig messages = Aurora.getMsg(event.getUser().getPlayer());
        AuroraUser user = event.getUser();
        if (this.config.getNotifyOnJoin().booleanValue() && user.getPlayer() != null && !user.getStashData().getItems().isEmpty()) {
            Chat.sendMessage(user.getPlayer(), messages.getStashAvailable(), new Placeholder[0]);
        }
    }

    private String a(List<String> aliases) {
        return String.join((CharSequence)"|", aliases);
    }

    public Config getConfig() {
        return this.config;
    }
}

