/*
 * Decompiled with CFR 0.152.
 */
package gg.auroramc.aurora.expansions.worldguard;

import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldguard.LocalPlayer;
import com.sk89q.worldguard.protection.ApplicableRegionSet;
import com.sk89q.worldguard.protection.regions.ProtectedRegion;
import com.sk89q.worldguard.session.MoveType;
import com.sk89q.worldguard.session.Session;
import com.sk89q.worldguard.session.handler.Handler;
import gg.auroramc.aurora.expansions.worldguard.WorldGuardExpansion;
import java.util.Set;
import org.bukkit.Location;

public class WorldGuardEntryAndLeaveHandler
extends Handler {
    private final WorldGuardExpansion expansion;

    public static Factory FACTORY(WorldGuardExpansion expansion) {
        return new Factory(expansion);
    }

    protected WorldGuardEntryAndLeaveHandler(Session session, WorldGuardExpansion expansion) {
        super(session);
        this.expansion = expansion;
    }

    public void initialize(LocalPlayer player, com.sk89q.worldedit.util.Location current, ApplicableRegionSet set) {
        this.expansion.onRegionUpdate(player.getUniqueId(), set.getRegions());
    }

    public boolean onCrossBoundary(LocalPlayer player, com.sk89q.worldedit.util.Location from, com.sk89q.worldedit.util.Location to, ApplicableRegionSet toSet, Set<ProtectedRegion> entered, Set<ProtectedRegion> exited, MoveType moveType) {
        if (this.expansion.checkFreeMoveAfterTeleport(player.getUniqueId(), BukkitAdapter.adapt((com.sk89q.worldedit.util.Location)to).getBlock().getLocation())) {
            return true;
        }
        if (moveType == MoveType.TELEPORT) {
            Location l = BukkitAdapter.adapt((com.sk89q.worldedit.util.Location)from).getBlock().getLocation();
            this.expansion.addTeleportMove(player.getUniqueId(), l);
        }
        this.expansion.onRegionUpdate(player.getUniqueId(), toSet.getRegions());
        return true;
    }

    public static class Factory
    extends Handler.Factory<WorldGuardEntryAndLeaveHandler> {
        private final WorldGuardExpansion expansion;

        public Factory(WorldGuardExpansion expansion) {
            this.expansion = expansion;
        }

        public WorldGuardEntryAndLeaveHandler create(Session session) {
            return new WorldGuardEntryAndLeaveHandler(session, this.expansion);
        }
    }
}

