/*
 * Decompiled with CFR 0.152.
 */
package gg.auroramc.aurora;

import gg.auroramc.aurora.api.AuroraLogger;
import gg.auroramc.aurora.api.dependency.Dep;
import gg.auroramc.aurora.api.dependency.DependencyManager;
import gg.auroramc.aurora.api.expansions.ExpansionManager;
import gg.auroramc.aurora.api.localization.AuroraLanguageProvider;
import gg.auroramc.aurora.api.localization.LanguageProvider;
import gg.auroramc.aurora.api.localization.LocalizationProvider;
import gg.auroramc.aurora.api.menu.MenuManager;
import gg.auroramc.aurora.api.user.UserLocalizationHolder;
import gg.auroramc.aurora.api.user.UserManager;
import gg.auroramc.aurora.api.user.UserMetaHolder;
import gg.auroramc.aurora.api.user.UserStashHolder;
import gg.auroramc.aurora.commands.CommandManager;
import gg.auroramc.aurora.config.Config;
import gg.auroramc.aurora.config.MessageConfig;
import gg.auroramc.aurora.expansions.economy.EconomyExpansion;
import gg.auroramc.aurora.expansions.entity.EntityExpansion;
import gg.auroramc.aurora.expansions.gui.GuiExpansion;
import gg.auroramc.aurora.expansions.item.ItemExpansion;
import gg.auroramc.aurora.expansions.itemstash.ItemStashExpansion;
import gg.auroramc.aurora.expansions.leaderboard.LeaderboardExpansion;
import gg.auroramc.aurora.expansions.numberformat.NumberFormatExpansion;
import gg.auroramc.aurora.expansions.placeholder.PlaceholderExpansion;
import gg.auroramc.aurora.expansions.region.RegionExpansion;
import gg.auroramc.aurora.expansions.worldguard.WorldGuardExpansion;
import gg.auroramc.aurora.hooks.LuckPermsHook;
import gg.auroramc.aurora.hooks.MythicMobsHook;
import gg.auroramc.aurora.hooks.WildToolsHook;
import gg.auroramc.aurora.libs.bstats.bukkit.Metrics;
import gg.auroramc.aurora.libs.bstats.charts.SimplePie;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.java.JavaPlugin;

public final class Aurora
extends JavaPlugin
implements Listener {
    private CommandManager commandManager;
    private static final MiniMessage miniMessage = MiniMessage.miniMessage();
    private static Config libConfig;
    private static Map<Locale, MessageConfig> messageConfigs;
    private static MenuManager menuManager;
    private static Aurora instance;
    private static UserManager userManager;
    private static ExpansionManager expansionManager;
    private static LanguageProvider languageProvider;
    private static LocalizationProvider localizationProvider;
    private static boolean disabling;
    private static final AuroraLogger l;

    public static AuroraLogger logger() {
        return l;
    }

    public void onLoad() {
        languageProvider = new AuroraLanguageProvider();
        this.saveDefaultConfig();
        instance = this;
        libConfig = new Config();
        libConfig.load();
        File oldFile = new File(this.getDataFolder(), "messages.yml");
        if (oldFile.exists()) {
            try {
                Files.move(oldFile.toPath(), this.getDataPath().resolve("messages_en.yml"), new CopyOption[0]);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        ArrayList<Locale> locales = new ArrayList<Locale>();
        for (String lang : libConfig.getSupportedLanguages()) {
            Locale locale = Locale.forLanguageTag(lang);
            MessageConfig.saveDefault(lang);
            MessageConfig messageConfig = new MessageConfig(lang);
            messageConfig.load();
            messageConfigs.put(locale, messageConfig);
            locales.add(locale);
        }
        languageProvider.setSupportedLocales(locales);
        languageProvider.setFallbackLocale(Locale.forLanguageTag(libConfig.getLocale()));
        expansionManager = new ExpansionManager();
        expansionManager.preloadExpansion(LeaderboardExpansion.class);
    }

    public void onEnable() {
        localizationProvider = new LocalizationProvider(languageProvider);
        for (Map.Entry<Locale, MessageConfig> msg : messageConfigs.entrySet()) {
            localizationProvider.setLocaleValues(msg.getKey(), msg.getValue().toFlatMap());
        }
        this.commandManager = new CommandManager(this);
        userManager = new UserManager();
        userManager.registerUserDataHolder(UserMetaHolder.class);
        userManager.registerUserDataHolder(UserStashHolder.class);
        userManager.registerUserDataHolder(UserLocalizationHolder.class);
        menuManager = new MenuManager(this);
        this.setupExpansions();
        if (DependencyManager.hasDep("LuckPerms")) {
            LuckPermsHook.registerListeners();
        }
        if (DependencyManager.hasDep("WildTools")) {
            WildToolsHook.hook();
        }
        if (DependencyManager.hasDep(Dep.MYTHICMOBS)) {
            MythicMobsHook.hook();
        }
        this.commandManager.reload();
        Metrics metrics = new Metrics(this, 23780);
        metrics.addCustomChart(new SimplePie("storage_type", () -> libConfig.getStorageType().equals("mysql") ? "mysql" : "yaml"));
    }

    public void onDisable() {
        disabling = true;
        userManager.stopTasksAndSaveAllData(true);
        expansionManager.getExpansion(LeaderboardExpansion.class).dispose();
    }

    private void setupExpansions() {
        expansionManager.loadExpansion(PlaceholderExpansion.class);
        expansionManager.loadExpansion(EconomyExpansion.class);
        expansionManager.loadExpansion(NumberFormatExpansion.class);
        expansionManager.loadExpansion(ItemExpansion.class);
        expansionManager.loadExpansion(EntityExpansion.class);
        expansionManager.loadExpansion(LeaderboardExpansion.class);
        expansionManager.loadExpansion(GuiExpansion.class);
        expansionManager.loadExpansion(ItemStashExpansion.class);
        if (DependencyManager.hasDep(Dep.WORLDGUARD)) {
            expansionManager.loadExpansion(WorldGuardExpansion.class);
        }
        if (libConfig.getBlockTracker().getEnabled().booleanValue()) {
            expansionManager.loadExpansion(RegionExpansion.class);
        }
    }

    public void reload() {
        libConfig = new Config();
        libConfig.load();
        ArrayList<Locale> locales = new ArrayList<Locale>();
        for (String string : libConfig.getSupportedLanguages()) {
            Locale locale = Locale.forLanguageTag(string);
            MessageConfig.saveDefault(string);
            MessageConfig messageConfig = new MessageConfig(string);
            messageConfig.load();
            messageConfigs.put(locale, messageConfig);
            locales.add(locale);
        }
        if (languageProvider instanceof AuroraLanguageProvider) {
            languageProvider.setSupportedLocales(locales);
            languageProvider.setFallbackLocale(Locale.forLanguageTag(libConfig.getLocale()));
        }
        localizationProvider.clear();
        for (Map.Entry entry : messageConfigs.entrySet()) {
            localizationProvider.setLocaleValues((Locale)entry.getKey(), ((MessageConfig)entry.getValue()).toFlatMap());
        }
        this.commandManager.reload();
        expansionManager.reloadExpansions();
    }

    public static MessageConfig getMsg(Player player) {
        if (libConfig.getUsePerPlayerLocale().booleanValue()) {
            return messageConfigs.get(languageProvider.getPlayerLocale(player));
        }
        return messageConfigs.get(Locale.forLanguageTag(libConfig.getLocale()));
    }

    public static MessageConfig getMsg(CommandSender sender) {
        if (sender instanceof Player) {
            Player player = (Player)sender;
            return Aurora.getMsg(player);
        }
        return messageConfigs.get(Locale.forLanguageTag(libConfig.getLocale()));
    }

    public CommandManager getCommandManager() {
        return this.commandManager;
    }

    public static MiniMessage getMiniMessage() {
        return miniMessage;
    }

    public static Config getLibConfig() {
        return libConfig;
    }

    public static Map<Locale, MessageConfig> getMessageConfigs() {
        return messageConfigs;
    }

    public static MenuManager getMenuManager() {
        return menuManager;
    }

    public static Aurora getInstance() {
        return instance;
    }

    public static UserManager getUserManager() {
        return userManager;
    }

    public static ExpansionManager getExpansionManager() {
        return expansionManager;
    }

    public static LanguageProvider getLanguageProvider() {
        return languageProvider;
    }

    public static void setLanguageProvider(LanguageProvider languageProvider) {
        Aurora.languageProvider = languageProvider;
    }

    public static LocalizationProvider getLocalizationProvider() {
        return localizationProvider;
    }

    public static boolean isDisabling() {
        return disabling;
    }

    static {
        messageConfigs = new HashMap<Locale, MessageConfig>();
        disabling = false;
        l = new AuroraLogger();
    }
}

