/*
 * Decompiled with CFR 0.152.
 */
package gg.auroramc.aurora.api.command;

import com.google.common.collect.Maps;
import gg.auroramc.aurora.Aurora;
import gg.auroramc.aurora.api.AuroraAPI;
import gg.auroramc.aurora.api.command.ArgumentParser;
import gg.auroramc.aurora.api.dependency.Dep;
import gg.auroramc.aurora.api.dependency.DependencyManager;
import gg.auroramc.aurora.api.item.TypeId;
import gg.auroramc.aurora.api.message.ActionBar;
import gg.auroramc.aurora.api.message.Placeholder;
import gg.auroramc.aurora.api.message.Text;
import gg.auroramc.aurora.api.user.UserMetaHolder;
import gg.auroramc.aurora.api.user.UserStashHolder;
import gg.auroramc.aurora.api.util.ItemUtils;
import gg.auroramc.aurora.api.util.TriConsumer;
import gg.auroramc.aurora.expansions.economy.AuroraEconomy;
import gg.auroramc.aurora.expansions.economy.EconomyExpansion;
import gg.auroramc.aurora.expansions.gui.GuiExpansion;
import gg.auroramc.aurora.hooks.LuckPermsHook;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import me.clip.placeholderapi.PlaceholderAPI;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.Sound;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.plugin.Plugin;

public class CommandDispatcher {
    private static final Map<String, BiConsumer<Player, String>> actions = Maps.newConcurrentMap();

    public static void registerActionHandler(String id, BiConsumer<Player, String> handler) {
        actions.put(id, handler);
    }

    public static Collection<String> getActions() {
        return actions.keySet();
    }

    private static Map.Entry<String, String> extractActionAndContent(String input) {
        int end;
        if (input.charAt(0) == '[' && (end = input.indexOf(93)) != -1) {
            String action = input.substring(1, end);
            String content = CommandDispatcher.removeFirstSpace(input.substring(end + 1));
            return new AbstractMap.SimpleEntry<String, String>(action, content);
        }
        return new AbstractMap.SimpleEntry<String, String>("default", input);
    }

    public static void dispatch(Player player, String command) {
        if (command.startsWith("[meta")) {
            UserMetaHolder data = Aurora.getUserManager().getUser(player).getMetaData();
            MetaRecord meta = CommandDispatcher.parseMetaString(command);
            if (meta.action == null) {
                return;
            }
            if (meta.key == null) {
                return;
            }
            switch (meta.action) {
                case "set": {
                    try {
                        double value = Double.parseDouble(meta.value);
                        data.setMeta(meta.key, value);
                    }
                    catch (NumberFormatException e) {
                        data.setMeta(meta.key, meta.value);
                    }
                    break;
                }
                case "remove": {
                    data.removeMeta(meta.key);
                    break;
                }
                case "increment": {
                    data.incrementMeta(meta.key, meta.value == null ? 1.0 : Double.parseDouble(meta.value));
                    break;
                }
                case "decrement": {
                    data.decrementMeta(meta.key, meta.value == null ? 1.0 : Double.parseDouble(meta.value));
                }
            }
            return;
        }
        Map.Entry<String, String> action = CommandDispatcher.extractActionAndContent(command);
        BiConsumer<Player, String> handler = actions.get(action.getKey());
        if (handler != null) {
            try {
                handler.accept(player, action.getValue());
            }
            catch (Exception e) {
                Aurora.logger().severe("Failed to execute action: " + action.getKey() + " with content: " + action.getValue() + " for player: " + player.getName() + " with error: " + e.getMessage());
                e.printStackTrace();
            }
        } else {
            Aurora.logger().warning("Invalid dispatcher action: " + action.getKey());
        }
    }

    public static void dispatch(Player player, String command, List<Placeholder<?>> placeholders) {
        CommandDispatcher.dispatch(player, Placeholder.execute(command, placeholders));
    }

    public static void dispatch(Player player, String command, Placeholder<?> ... placeholders) {
        CommandDispatcher.dispatch(player, Placeholder.execute(command, placeholders));
    }

    private static void runConsoleCommand(Player player, String command) {
        Bukkit.getGlobalRegionScheduler().run((Plugin)Aurora.getInstance(), task -> {
            String cmd = DependencyManager.hasDep(Dep.PAPI) ? PlaceholderAPI.setPlaceholders((Player)player, (String)command) : command;
            Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)cmd);
        });
    }

    private static void runPlayerCommand(Player player, String command) {
        player.getScheduler().run((Plugin)Aurora.getInstance(), task -> {
            String cmd = DependencyManager.hasDep(Dep.PAPI) ? PlaceholderAPI.setPlaceholders((Player)player, (String)command) : command;
            player.performCommand(cmd);
        }, null);
    }

    private static void playSound(Player player, String cmd) {
        String[] args = cmd.split(" ");
        if (args.length == 0) {
            return;
        }
        Sound sound = (Sound)Registry.SOUNDS.get(NamespacedKey.fromString((String)args[0]));
        if (sound == null) {
            Aurora.logger().warning("Invalid sound: " + args[0]);
            return;
        }
        if (args.length == 1) {
            player.playSound((Entity)player, sound, 1.0f, 1.0f);
        } else if (args.length == 2) {
            player.playSound(player.getLocation(), sound, Float.parseFloat(args[1]), 1.0f);
        } else if (args.length == 3) {
            player.playSound(player.getLocation(), sound, Float.parseFloat(args[1]), Float.parseFloat(args[2]));
        }
    }

    private static MetaRecord parseMetaString(String input) {
        Pattern pattern = Pattern.compile("\\[meta:(set|remove|increment|decrement):([a-zA-Z0-9_-]+)]\\s*(.*)");
        Matcher matcher = pattern.matcher(input);
        if (matcher.matches()) {
            String action = matcher.group(1);
            String key = matcher.group(2);
            String value = matcher.group(3).isEmpty() ? null : matcher.group(3);
            return new MetaRecord(action, key, value);
        }
        return new MetaRecord(null, null, null);
    }

    private static String removeFirstSpace(String text) {
        if (text.startsWith(" ")) {
            return text.substring(1);
        }
        return text;
    }

    private static void useEconomy(String input, TriConsumer<AuroraEconomy, String, Double> action) {
        EconomyExpansion expansion = Aurora.getExpansionManager().getExpansion(EconomyExpansion.class);
        AuroraEconomy econ = expansion.getDefaultEconomy();
        Map<String, String> args = ArgumentParser.parseString(input);
        if (args.containsKey("economy")) {
            econ = expansion.getEconomy(args.get("economy"));
        }
        if (econ == null) {
            Aurora.logger().warning("Invalid economy provider: " + args.get("economy"));
            return;
        }
        if (!(!args.containsKey("currency") || econ.supportsCurrency() && econ.validateCurrency(args.get("currency")))) {
            Aurora.logger().warning("Currency " + args.get("currency") + " is not supported by economy provider " + args.get("economy") + ". Please check your configuration.");
            return;
        }
        action.accept(econ, args.getOrDefault("currency", "default"), Double.parseDouble(args.get("prefix")));
    }

    private static void giveItem(Player player, String input) {
        String[] args = input.split(" ");
        String[] split = args[0].split("/");
        boolean stash = args.length > 1 && args[1].equalsIgnoreCase("true");
        TypeId typeId = TypeId.fromDefault(split[0]);
        int amount = Integer.parseInt(split[1]);
        ItemStack item = AuroraAPI.getItemManager().resolveItem(typeId);
        if (item == null || item.isEmpty()) {
            Aurora.logger().warning("Failed to resolve item: " + String.valueOf(typeId));
            return;
        }
        ItemStack[] stacks = ItemUtils.createStacksFromAmount(item, amount);
        HashMap failed = player.getInventory().addItem(stacks);
        if (!failed.isEmpty()) {
            if (stash) {
                UserStashHolder data = Aurora.getUserManager().getUser(player).getStashData();
                for (ItemStack stack : stacks) {
                    data.addItem(stack);
                }
            } else {
                Bukkit.getRegionScheduler().run((Plugin)Aurora.getInstance(), player.getLocation(), t -> failed.forEach((index, itemStack) -> player.getWorld().dropItem(player.getLocation(), itemStack)));
            }
        }
    }

    private static void takeItems(Player player, String input) {
        List<ItemData> items = Stream.of(input.split(" ")).map(id -> {
            String[] split = id.split("/");
            TypeId typeId = TypeId.fromDefault(split[0]);
            return new ItemData(AuroraAPI.getItemManager().resolveItem(typeId), typeId, Integer.parseInt(split[1]));
        }).toList();
        PlayerInventory inv = player.getInventory();
        boolean success = true;
        for (ItemData itemData : items) {
            if (inv.containsAtLeast(AuroraAPI.getItemManager().resolveItem(itemData.typeId()), itemData.amount)) continue;
            success = false;
            break;
        }
        if (success) {
            for (ItemStack item : inv.getContents()) {
                if (item == null || item.isEmpty()) continue;
                for (ItemData itemData : items) {
                    if (itemData.amount() == 0 || !AuroraAPI.getItemManager().resolveId(item).equals(itemData.typeId())) continue;
                    int decrementAmount = Math.min(itemData.amount(), item.getAmount());
                    itemData.decrement(decrementAmount);
                    item.setAmount(item.getAmount() - decrementAmount);
                }
            }
        }
    }

    static {
        CommandDispatcher.registerActionHandler("default", CommandDispatcher::runConsoleCommand);
        CommandDispatcher.registerActionHandler("console", CommandDispatcher::runConsoleCommand);
        CommandDispatcher.registerActionHandler("player", CommandDispatcher::runPlayerCommand);
        CommandDispatcher.registerActionHandler("message", (player, message) -> player.sendMessage(Text.component(player, message, new Placeholder[0])));
        CommandDispatcher.registerActionHandler("actionbar", (x$0, x$1) -> ActionBar.send(x$0, x$1, new Placeholder[0]));
        CommandDispatcher.registerActionHandler("sound", CommandDispatcher::playSound);
        CommandDispatcher.registerActionHandler("permission", (player, input) -> {
            if (DependencyManager.hasDep("LuckPerms")) {
                Map<String, String> args = ArgumentParser.parseString(input);
                LuckPermsHook.grantPermission(player, args.get("prefix"), args);
            }
        });
        CommandDispatcher.registerActionHandler("close", (player, command) -> player.getScheduler().run((Plugin)Aurora.getInstance(), task -> player.closeInventory(), null));
        CommandDispatcher.registerActionHandler("open-gui", (player, input) -> {
            Map<String, String> args = ArgumentParser.parseString(input);
            Aurora.getExpansionManager().getExpansion(GuiExpansion.class).openGui(args.get("prefix"), (Player)player, args);
        });
        CommandDispatcher.registerActionHandler("take-items", CommandDispatcher::takeItems);
        CommandDispatcher.registerActionHandler("give-item", CommandDispatcher::giveItem);
        CommandDispatcher.registerActionHandler("placeholder", (player, placeholder) -> {
            if (DependencyManager.hasDep(Dep.PAPI)) {
                PlaceholderAPI.setPlaceholders((Player)player, (String)placeholder);
            }
        });
        CommandDispatcher.registerActionHandler("give-money", (player, input) -> CommandDispatcher.useEconomy(input, (econ, currency, amount) -> econ.deposit((Player)player, (String)currency, (double)amount)));
        CommandDispatcher.registerActionHandler("take-money", (player, input) -> CommandDispatcher.useEconomy(input, (econ, currency, amount) -> econ.withdraw((Player)player, (String)currency, (double)amount)));
    }

    public record MetaRecord(String action, String key, String value) {
    }

    public static class ItemData {
        private final TypeId typeId;
        private int amount;
        private final ItemStack item;

        public ItemData(ItemStack item, TypeId typeId, int amount) {
            this.typeId = typeId;
            this.amount = amount;
            this.item = item;
        }

        public TypeId typeId() {
            return this.typeId;
        }

        public int amount() {
            return this.amount;
        }

        public void decrement(int amount) {
            this.amount -= amount;
        }

        public ItemStack item() {
            return this.item;
        }
    }
}

