/*
 * Decompiled with CFR 0.152.
 */
package gg.auroramc.aurora.api.entity;

import gg.auroramc.aurora.api.dependency.Dep;
import gg.auroramc.aurora.api.entity.EntityResolver;
import gg.auroramc.aurora.api.entity.EntitySpawner;
import gg.auroramc.aurora.api.entity.VanillaEntityResolver;
import gg.auroramc.aurora.api.item.TypeId;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.Nullable;

public class EntityManager {
    private final VanillaEntityResolver vanillaEntityResolver = new VanillaEntityResolver();
    private final Map<String, EntityResolver> resolvers = new LinkedHashMap<String, EntityResolver>();

    public void registerResolver(String plugin, EntityResolver resolver) {
        this.resolvers.put(plugin, resolver);
    }

    public void registerResolver(Dep plugin, EntityResolver resolver) {
        this.resolvers.put(plugin.getId().toLowerCase(Locale.ROOT), resolver);
    }

    public EntityResolver getResolver(String plugin) {
        return this.resolvers.get(plugin);
    }

    public void unregisterResolver(String plugin) {
        this.resolvers.remove(plugin.toLowerCase(Locale.ROOT));
    }

    public TypeId resolveId(Entity entity) {
        for (EntityResolver resolver : this.resolvers.values()) {
            if (!resolver.matches(entity)) continue;
            return resolver.resolveId(entity);
        }
        return TypeId.from(entity.getType());
    }

    public EntitySpawner resolveEntitySpawner(TypeId typeId, @Nullable Player player) {
        if (typeId.namespace().equalsIgnoreCase("minecraft")) {
            return this.vanillaEntityResolver.resolveEntitySpawner(typeId.id(), player);
        }
        for (Map.Entry<String, EntityResolver> resolver : this.resolvers.entrySet()) {
            if (!resolver.getKey().equalsIgnoreCase(typeId.namespace())) continue;
            return resolver.getValue().resolveEntitySpawner(typeId.id(), player);
        }
        return this.vanillaEntityResolver.resolveEntitySpawner(typeId.id(), player);
    }

    public EntitySpawner resolveEntitySpawner(TypeId typeId) {
        return this.resolveEntitySpawner(typeId, null);
    }
}

