/*
 * Decompiled with CFR 0.152.
 */
package gg.auroramc.aurora.api.expression;

import gg.auroramc.aurora.api.message.Placeholder;
import gg.auroramc.aurora.libs.exp4j.Expression;
import gg.auroramc.aurora.libs.exp4j.ExpressionBuilder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CompiledNumberExpression {
    private final Expression expression;
    private final Map<String, Double> cache = new HashMap<String, Double>();

    public CompiledNumberExpression(String expression, List<String> placeholders) {
        this.expression = new ExpressionBuilder(expression).variables((String[])placeholders.stream().map(pl -> pl.replace("{", "").replace("}", "")).toArray(String[]::new)).build();
    }

    public static CompiledNumberExpression expression(String expression, List<String> placeholders) {
        return new CompiledNumberExpression(expression, placeholders);
    }

    public double evaluate(List<Placeholder<?>> variables) {
        for (Placeholder<?> variable : variables) {
            Object obj = variable.getValue();
            if (!(obj instanceof Number)) continue;
            Number num = (Number)obj;
            if (variable.getKey().startsWith("{")) {
                this.expression.setVariable(variable.getKey().replace("{", "").replace("}", ""), num.doubleValue());
                continue;
            }
            this.expression.setVariable(variable.getKey(), num.doubleValue());
        }
        return this.expression.evaluate();
    }

    public double cachedEvaluate(List<Placeholder<?>> variables) {
        String cacheKey = this.generateCacheKey(variables);
        if (this.cache.containsKey(cacheKey)) {
            return this.cache.get(cacheKey);
        }
        double result = this.evaluate(variables);
        this.cache.put(cacheKey, result);
        return result;
    }

    private String generateCacheKey(List<Placeholder<?>> variables) {
        StringBuilder keyBuilder = new StringBuilder();
        for (Placeholder<?> variable : variables) {
            if (!(variable.getValue() instanceof Number)) continue;
            keyBuilder.append(variable.getKey()).append("=").append(variable.getValue()).append(";");
        }
        return keyBuilder.toString();
    }
}

