/*
 * Decompiled with CFR 0.152.
 */
package gg.auroramc.aurora.api.item;

import gg.auroramc.aurora.Aurora;
import gg.auroramc.aurora.api.dependency.Dep;
import gg.auroramc.aurora.api.item.ItemResolver;
import gg.auroramc.aurora.api.item.TypeId;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.Nullable;

public class ItemManager {
    private final List<RegisteredResolver> resolvers = new ArrayList<RegisteredResolver>();
    private final Map<String, RegisteredResolver> resolverMap = new HashMap<String, RegisteredResolver>();

    public void registerResolver(String plugin, ItemResolver resolver) {
        String pluginId = plugin.toLowerCase(Locale.ROOT);
        int priority = Aurora.getLibConfig().getItemResolverPriorities().getOrDefault(pluginId, 0);
        this.registerResolver(pluginId, resolver, priority);
    }

    public void registerResolver(Dep plugin, ItemResolver resolver) {
        String pluginId = plugin.getId().toLowerCase(Locale.ROOT);
        int priority = Aurora.getLibConfig().getItemResolverPriorities().getOrDefault(pluginId, 0);
        this.registerResolver(pluginId, resolver, priority);
    }

    public void registerResolver(String plugin, ItemResolver resolver, int priority) {
        String pluginId = plugin.toLowerCase(Locale.ROOT);
        this.insertSorted(new RegisteredResolver(pluginId, resolver, priority));
        Aurora.logger().info("Registered item resolver " + pluginId + " with priority " + priority);
    }

    public void registerResolver(Dep plugin, ItemResolver resolver, int priority) {
        this.registerResolver(plugin.getId().toLowerCase(Locale.ROOT), resolver, priority);
    }

    public void unregisterResolver(String plugin) {
        this.resolvers.removeIf(r -> r.plugin().equalsIgnoreCase(plugin));
        this.resolverMap.remove(plugin);
    }

    @Nullable
    public ItemResolver getResolver(String plugin) {
        return this.resolverMap.get((Object)plugin).resolver;
    }

    public TypeId resolveId(ItemStack item) {
        if (item.getType() == Material.AIR) {
            return TypeId.from(Material.AIR);
        }
        for (RegisteredResolver r : this.resolvers) {
            TypeId res = r.resolver().oneStepMatch(item);
            if (res == null) continue;
            return res;
        }
        return TypeId.from(item.getType());
    }

    public ItemStack resolveItem(TypeId typeId, @Nullable Player player) {
        RegisteredResolver r;
        ItemStack item;
        if (typeId.namespace().equalsIgnoreCase("minecraft")) {
            return this.resolveVanilla(typeId);
        }
        if (this.resolverMap.containsKey(typeId.namespace()) && (item = (r = this.resolverMap.get(typeId.namespace())).resolver().resolveItem(typeId.id(), player)) != null && item.getType() != Material.AIR) {
            return item;
        }
        return this.resolveVanilla(typeId);
    }

    private ItemStack resolveVanilla(TypeId typeId) {
        try {
            return new ItemStack(Material.valueOf((String)typeId.id().toUpperCase(Locale.ROOT)));
        }
        catch (IllegalArgumentException e) {
            Aurora.logger().warning("Failed to resolve item: " + String.valueOf(typeId) + " using AIR instead.");
            return new ItemStack(Material.AIR);
        }
    }

    public ItemStack resolveItem(TypeId typeId) {
        return this.resolveItem(typeId, null);
    }

    public List<RegisteredResolver> getResolvers() {
        return Collections.unmodifiableList(this.resolvers);
    }

    private void insertSorted(RegisteredResolver newResolver) {
        this.resolverMap.put(newResolver.plugin(), newResolver);
        for (int i = 0; i < this.resolvers.size(); ++i) {
            int existingPriority = this.resolvers.get(i).priority();
            int newPriority = newResolver.priority();
            if (newPriority <= existingPriority) continue;
            this.resolvers.add(i, newResolver);
            return;
        }
        this.resolvers.add(newResolver);
    }

    public record RegisteredResolver(String plugin, ItemResolver resolver, Integer priority) {
    }
}

