/*
 * Decompiled with CFR 0.152.
 */
package gg.auroramc.aurora.api.menu;

import gg.auroramc.aurora.Aurora;
import gg.auroramc.aurora.api.menu.MenuItemMarker;
import org.bukkit.Bukkit;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityPickupItemEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerLoginEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class MenuDupeFixer
implements Listener {
    private final Aurora plugin;
    private final MenuItemMarker marker;

    public MenuDupeFixer(Aurora plugin) {
        this.plugin = plugin;
        this.marker = new MenuItemMarker(plugin, "aurora");
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    @EventHandler
    private void onPickup(EntityPickupItemEvent event) {
        if (!this.marker.isMarked(event.getItem().getItemStack())) {
            return;
        }
        this.plugin.getLogger().warning(event.getEntity().getName() + " picked up an AuroraMenu item. Removing it.");
        event.getItem().remove();
    }

    @EventHandler
    private void onDrop(PlayerDropItemEvent event) {
        if (!this.marker.isMarked(event.getItemDrop().getItemStack())) {
            return;
        }
        Aurora.logger().warning("An AuroraMenu item was dropped in the world by " + event.getPlayer().getName() + ". Removing it.");
        event.getItemDrop().remove();
    }

    @EventHandler
    private void onLogin(PlayerLoginEvent event) {
        event.getPlayer().getScheduler().runDelayed((Plugin)this.plugin, task -> {
            for (ItemStack itemStack : event.getPlayer().getInventory().getContents()) {
                if (itemStack == null || !this.marker.isMarked(itemStack)) continue;
                this.plugin.getLogger().warning(event.getPlayer().getName() + " logged in with a AuroraMenu item in their inventory. Removing it.");
                event.getPlayer().getInventory().remove(itemStack);
            }
        }, null, 10L);
    }

    public MenuItemMarker getMarker() {
        return this.marker;
    }
}

