/*
 * Decompiled with CFR 0.152.
 */
package gg.auroramc.aurora.api.menu;

import gg.auroramc.aurora.api.command.CommandDispatcher;
import gg.auroramc.aurora.api.menu.ItemBuilder;
import gg.auroramc.aurora.api.message.Placeholder;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class MenuItem {
    private final ItemBuilder itemBuilder;
    private List<Placeholder<?>> placeholders;
    private ItemStack itemStack;
    private final Player player;

    public MenuItem(Player player, ItemBuilder builder, ItemStack itemStack) {
        this.itemBuilder = builder;
        this.itemStack = itemStack;
        this.player = player;
        ArrayList placeholders = new ArrayList(this.itemBuilder.getPlaceholders());
        placeholders.add(Placeholder.of("{player}", player.getName()));
        this.placeholders = placeholders;
    }

    @Deprecated(forRemoval=true)
    public void applyToInventory(Inventory inventory) {
        if (this.itemBuilder.getConfig().getSlot() != null) {
            inventory.setItem(this.itemBuilder.getConfig().getSlot().intValue(), this.itemStack);
        } else if (this.itemBuilder.getConfig().getSlots() != null && !this.itemBuilder.getConfig().getSlots().isEmpty()) {
            this.itemBuilder.getConfig().getSlots().forEach(s -> inventory.setItem(s.intValue(), this.itemStack));
        }
    }

    public void runOnClickCommands(Player player) {
        if (this.itemBuilder.getConfig().getOnClick() == null) {
            return;
        }
        this.itemBuilder.getConfig().getOnClick().forEach(c -> CommandDispatcher.dispatch(player, c, this.placeholders));
    }

    public void runOnLeftClickCommands(Player player) {
        if (this.itemBuilder.getConfig().getOnLeftClick() == null) {
            return;
        }
        this.itemBuilder.getConfig().getOnLeftClick().forEach(c -> CommandDispatcher.dispatch(player, c, this.placeholders));
    }

    public void runOnRightClickCommands(Player player) {
        if (this.itemBuilder.getConfig().getOnRightClick() == null) {
            return;
        }
        this.itemBuilder.getConfig().getOnRightClick().forEach(c -> CommandDispatcher.dispatch(player, c, this.placeholders));
    }

    public void refresh() {
        this.itemStack = this.itemBuilder.build(this.player).getItemStack();
        ArrayList placeholders = new ArrayList(this.itemBuilder.getPlaceholders());
        placeholders.add(Placeholder.of("{player}", this.player.getName()));
        this.placeholders = placeholders;
    }

    public boolean isRefreshEnabled() {
        return this.itemBuilder.getConfig().isRefresh();
    }

    public List<Integer> getSlots() {
        return this.itemBuilder.getConfig().getSlot() != null ? List.of(this.itemBuilder.getConfig().getSlot()) : this.itemBuilder.getConfig().getSlots();
    }

    public ItemBuilder getItemBuilder() {
        return this.itemBuilder;
    }

    public ItemStack getItemStack() {
        return this.itemStack;
    }

    public Player getPlayer() {
        return this.player;
    }

    public List<Placeholder<?>> getPlaceholders() {
        return this.placeholders;
    }
}

