/*
 * Decompiled with CFR 0.152.
 */
package gg.auroramc.aurora.api.menu;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import gg.auroramc.aurora.Aurora;
import gg.auroramc.aurora.api.menu.AuroraMenu;
import gg.auroramc.aurora.api.menu.MenuDupeFixer;
import gg.auroramc.aurora.api.menu.MenuItemMarker;
import gg.auroramc.aurora.api.menu.MenuRefresher;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class MenuManager
implements Listener {
    private final MenuDupeFixer dupeFixer;
    private final MenuRefresher refresher;
    private final Cache<UUID, Long> cache = CacheBuilder.newBuilder().expireAfterWrite(75L, TimeUnit.MILLISECONDS).build();
    private final Cache<UUID, Long> shiftCache = CacheBuilder.newBuilder().expireAfterWrite(200L, TimeUnit.MILLISECONDS).build();

    public MenuManager(Aurora plugin) {
        this.dupeFixer = new MenuDupeFixer(plugin);
        this.refresher = new MenuRefresher(plugin);
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGHEST)
    public void onMenuClick(InventoryClickEvent event) {
        InventoryHolder inventoryHolder = event.getInventory().getHolder();
        if (inventoryHolder instanceof AuroraMenu) {
            boolean valid;
            AuroraMenu menu = (AuroraMenu)inventoryHolder;
            event.setCancelled(true);
            if (event.getClickedInventory() != null && !(event.getClickedInventory().getHolder() instanceof AuroraMenu)) {
                if (menu.hasFreeSlots()) {
                    event.setCancelled(false);
                    if (event.isShiftClick()) {
                        menu.handleFreeSlotUpdate(event.getInventory());
                    }
                }
                return;
            }
            if (this.cache.getIfPresent((Object)event.getWhoClicked().getUniqueId()) != null) {
                return;
            }
            if (this.shiftCache.getIfPresent((Object)event.getWhoClicked().getUniqueId()) != null) {
                return;
            }
            if (event.getClick() == ClickType.DOUBLE_CLICK) {
                return;
            }
            if (event.getClick() == ClickType.SHIFT_LEFT) {
                this.shiftCache.put((Object)event.getWhoClicked().getUniqueId(), (Object)System.currentTimeMillis());
            }
            if (valid = menu.handleEvent(event)) {
                this.cache.put((Object)event.getWhoClicked().getUniqueId(), (Object)System.currentTimeMillis());
            }
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onDrag(InventoryDragEvent event) {
        AuroraMenu menu;
        InventoryHolder inventoryHolder = event.getInventory().getHolder();
        if (inventoryHolder instanceof AuroraMenu && (menu = (AuroraMenu)inventoryHolder).hasFreeSlots()) {
            for (Integer slot : event.getInventorySlots()) {
                if (!menu.isFreeSlot(slot)) continue;
                menu.handleFreeSlotUpdate(event.getInventory());
                return;
            }
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGHEST)
    public void onMenuClose(InventoryCloseEvent event) {
        InventoryHolder inventoryHolder = event.getInventory().getHolder();
        if (inventoryHolder instanceof AuroraMenu) {
            AuroraMenu menu = (AuroraMenu)inventoryHolder;
            menu.handleEvent(event);
            event.getPlayer().getScheduler().runDelayed((Plugin)Aurora.getInstance(), task -> this.cleanInventory((Player)event.getPlayer(), this.dupeFixer.getMarker()), null, 3L);
        }
    }

    public void cleanInventory(Player player, MenuItemMarker marker) {
        if (player == null) {
            return;
        }
        for (ItemStack itemStack : player.getInventory().getContents()) {
            if (itemStack == null || !marker.isMarked(itemStack)) continue;
            Aurora.getInstance().getLogger().warning("Found a AuroraMenu item in a player's inventory. Removing it.");
            player.getInventory().remove(itemStack);
        }
        player.updateInventory();
    }

    public MenuDupeFixer getDupeFixer() {
        return this.dupeFixer;
    }

    public MenuRefresher getRefresher() {
        return this.refresher;
    }

    public Cache<UUID, Long> getCache() {
        return this.cache;
    }

    public Cache<UUID, Long> getShiftCache() {
        return this.shiftCache;
    }
}

