/*
 * Decompiled with CFR 0.152.
 */
package gg.auroramc.aurora.api.menu;

import com.google.common.collect.Maps;
import gg.auroramc.aurora.Aurora;
import gg.auroramc.aurora.api.AuroraAPI;
import gg.auroramc.aurora.api.command.CommandDispatcher;
import gg.auroramc.aurora.api.config.premade.RequirementConfig;
import gg.auroramc.aurora.api.dependency.Dep;
import gg.auroramc.aurora.api.dependency.DependencyManager;
import gg.auroramc.aurora.api.item.TypeId;
import gg.auroramc.aurora.api.message.Placeholder;
import gg.auroramc.aurora.api.user.AuroraUser;
import gg.auroramc.aurora.api.user.UserMetaHolder;
import gg.auroramc.aurora.expansions.economy.AuroraEconomy;
import gg.auroramc.aurora.expansions.economy.EconomyExpansion;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import me.clip.placeholderapi.PlaceholderAPI;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class Requirement {
    private static final Map<String, BiFunction<Player, String[], Boolean>> resolvers = Maps.newConcurrentMap();

    public static void register(String name, BiFunction<Player, String[], Boolean> resolver) {
        resolvers.put("[" + name + "]", resolver);
    }

    public static boolean isAllMet(Player player, List<String> requirements, List<Placeholder<?>> placeholders) {
        if (requirements == null) {
            return true;
        }
        for (String requirement : requirements) {
            if (Requirement.isMet(player, requirement, placeholders)) continue;
            return false;
        }
        return true;
    }

    public static boolean passes(Player player, List<RequirementConfig> requirements, List<Placeholder<?>> placeholders) {
        if (requirements == null) {
            return true;
        }
        for (RequirementConfig requirement : requirements) {
            if (Requirement.isMet(player, requirement.getRequirement(), placeholders)) continue;
            if (requirement.getDenyActions() != null) {
                requirement.getDenyActions().forEach(action -> CommandDispatcher.dispatch(player, action, placeholders));
            }
            return false;
        }
        return true;
    }

    public static boolean isMet(Player player, String requirement, List<Placeholder<?>> placeholders) {
        String placeholderValue;
        if (requirement == null || requirement.isEmpty()) {
            return true;
        }
        if (requirement.startsWith("!")) {
            return !Requirement.isMet(player, requirement.substring(1), placeholders);
        }
        if ((requirement = Placeholder.execute(requirement, placeholders)).startsWith("[permission]")) {
            String perm = requirement.substring(13);
            return player.hasPermission(perm);
        }
        String[] args = requirement.split(" ");
        if (args[0].equalsIgnoreCase("[money]")) {
            EconomyExpansion expansion = Aurora.getExpansionManager().getExpansion(EconomyExpansion.class);
            AuroraEconomy economy = args.length > 2 ? expansion.getEconomy(args[2]) : expansion.getDefaultEconomy();
            String currency = null;
            if (args.length > 3) {
                currency = args[3];
            }
            if (currency != null) {
                if (economy.supportsCurrency() && economy.validateCurrency(currency)) {
                    return economy.hasBalance(player, currency, Double.parseDouble(args[1]));
                }
                Aurora.logger().warning("Currency " + currency + " is not supported by economy provider " + String.valueOf(economy) + ". Please check your requirement configuration: " + requirement);
            } else {
                return economy.hasBalance(player, Double.parseDouble(args[1]));
            }
        }
        if (args[0].equalsIgnoreCase("[exp-level]")) {
            return player.getLevel() >= Integer.parseInt(args[1]);
        }
        if (args[0].equalsIgnoreCase("[placeholder]")) {
            if (!DependencyManager.hasDep(Dep.PAPI)) {
                return false;
            }
            placeholderValue = PlaceholderAPI.setPlaceholders((Player)player, (String)Placeholder.execute(args[1], placeholders));
            return Requirement.doPlaceholderCheck(player, args, placeholderValue, placeholders);
        }
        if (args[0].equalsIgnoreCase("[arg]")) {
            placeholderValue = Placeholder.execute("{arg_" + args[1] + "}", placeholders);
            return Requirement.doPlaceholderCheck(player, args, placeholderValue, placeholders);
        }
        if (args[0].equalsIgnoreCase("[meta]")) {
            String metaKey = Placeholder.execute(args[1], placeholders);
            return Requirement.doMetaCheck(player, args, metaKey, placeholders);
        }
        if (args[0].equalsIgnoreCase("[has-items]")) {
            for (int i = 1; i < args.length; ++i) {
                String[] split = args[i].split("/");
                ItemStack item = AuroraAPI.getItemManager().resolveItem(TypeId.fromDefault(split[0]));
                int amount = Integer.parseInt(split[1]);
                if (player.getInventory().containsAtLeast(item, amount)) continue;
                return false;
            }
            return true;
        }
        BiFunction<Player, String[], Boolean> customResolver = resolvers.get(args[0]);
        if (customResolver != null) {
            return customResolver.apply(player, args);
        }
        return false;
    }

    private static boolean doPlaceholderCheck(Player player, String[] args, String placeholderValue, List<Placeholder<?>> placeholders) {
        String compareValue = Placeholder.execute(String.join((CharSequence)" ", Arrays.copyOfRange(args, 3, args.length)), placeholders);
        if (DependencyManager.hasDep(Dep.PAPI)) {
            compareValue = PlaceholderAPI.setPlaceholders((Player)player, (String)compareValue);
        }
        return switch (args[2]) {
            case "==" -> placeholderValue.equals(compareValue);
            case "===" -> {
                if (Double.parseDouble(placeholderValue) == Double.parseDouble(compareValue)) {
                    yield true;
                }
                yield false;
            }
            case ">=" -> {
                if (Double.parseDouble(placeholderValue) >= Double.parseDouble(compareValue)) {
                    yield true;
                }
                yield false;
            }
            case "<=" -> {
                if (Double.parseDouble(placeholderValue) <= Double.parseDouble(compareValue)) {
                    yield true;
                }
                yield false;
            }
            case "<" -> {
                if (Double.parseDouble(placeholderValue) < Double.parseDouble(compareValue)) {
                    yield true;
                }
                yield false;
            }
            case ">" -> {
                if (Double.parseDouble(placeholderValue) > Double.parseDouble(compareValue)) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }

    private static boolean doMetaCheck(Player player, String[] args, String metaKey, List<Placeholder<?>> placeholders) {
        AuroraUser user;
        String compareValue = Placeholder.execute(String.join((CharSequence)" ", Arrays.copyOfRange(args, 3, args.length)), placeholders);
        if (DependencyManager.hasDep(Dep.PAPI)) {
            compareValue = PlaceholderAPI.setPlaceholders((Player)player, (String)compareValue);
        }
        if (!(user = Aurora.getUserManager().getUser(player)).isLoaded()) {
            return false;
        }
        UserMetaHolder metaData = user.getMetaData();
        return switch (args[2]) {
            case "==" -> metaData.getMeta(metaKey, "").equals(compareValue);
            case "===" -> {
                if (metaData.getMeta(metaKey, 0.0) == Double.parseDouble(compareValue)) {
                    yield true;
                }
                yield false;
            }
            case ">=" -> {
                if (metaData.getMeta(metaKey, 0.0) >= Double.parseDouble(compareValue)) {
                    yield true;
                }
                yield false;
            }
            case "<=" -> {
                if (metaData.getMeta(metaKey, 0.0) <= Double.parseDouble(compareValue)) {
                    yield true;
                }
                yield false;
            }
            case "<" -> {
                if (metaData.getMeta(metaKey, 0.0) < Double.parseDouble(compareValue)) {
                    yield true;
                }
                yield false;
            }
            case ">" -> {
                if (metaData.getMeta(metaKey, 0.0) > Double.parseDouble(compareValue)) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }
}

