/*
 * Decompiled with CFR 0.152.
 */
package gg.auroramc.aurora.api.reward;

import gg.auroramc.aurora.Aurora;
import gg.auroramc.aurora.api.command.CommandDispatcher;
import gg.auroramc.aurora.api.expression.BooleanExpression;
import gg.auroramc.aurora.api.message.Placeholder;
import gg.auroramc.aurora.api.reward.AbstractReward;
import java.util.List;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;

public class CommandReward
extends AbstractReward {
    private List<String> commands;
    private String correctionExpression;

    @Override
    public void execute(Player player, long level, List<Placeholder<?>> formulaPlaceholders) {
        if (this.commands == null) {
            return;
        }
        for (String command : this.commands) {
            CommandDispatcher.dispatch(player, command, formulaPlaceholders);
        }
    }

    @Override
    public void init(ConfigurationSection args) {
        super.init(args);
        if (args.isString("command") && args.getString("command") != null) {
            this.commands = List.of(args.getString("command"));
        } else if (args.isList("command")) {
            this.commands = args.getStringList("command");
        } else {
            this.commands = List.of();
            Aurora.logger().warning("CommandReward doesn't have the command key");
        }
        this.correctionExpression = args.getString("correction-condition");
    }

    public boolean shouldBeCorrected(Player player, long level) {
        if (this.correctionExpression == null || this.commands == null) {
            return false;
        }
        return BooleanExpression.eval(player, this.correctionExpression, Placeholder.of("{level}", level));
    }

    public List<String> getCommands() {
        return this.commands;
    }
}

