/*
 * Decompiled with CFR 0.152.
 */
package gg.auroramc.aurora.api.reward;

import gg.auroramc.aurora.Aurora;
import gg.auroramc.aurora.api.config.ConfigManager;
import gg.auroramc.aurora.api.config.premade.ItemConfig;
import gg.auroramc.aurora.api.menu.ItemBuilder;
import gg.auroramc.aurora.api.message.Placeholder;
import gg.auroramc.aurora.api.reward.AbstractReward;
import gg.auroramc.aurora.api.user.UserStashHolder;
import gg.auroramc.aurora.api.util.ItemUtils;
import gg.auroramc.aurora.api.util.ThreadSafety;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class ItemReward
extends AbstractReward {
    private ItemConfig itemConfig;
    private StashHandle stash = StashHandle.NONE;

    @Override
    public void execute(Player player, long level, List<Placeholder<?>> placeholders) {
        if (this.itemConfig == null) {
            return;
        }
        if (this.stash == StashHandle.FORCE) {
            ItemStack[] items = this.getItems(player, placeholders);
            if (items == null) {
                return;
            }
            UserStashHolder stashHolder = Aurora.getUserManager().getUser(player.getUniqueId()).getStashData();
            for (ItemStack i : items) {
                stashHolder.addItem(i);
            }
            return;
        }
        player.getScheduler().run((Plugin)Aurora.getInstance(), task -> {
            ItemStack[] items = this.getItems(player, placeholders);
            if (items == null) {
                return;
            }
            if (this.stash == StashHandle.NONE) {
                HashMap failed = player.getInventory().addItem(items);
                if (failed.isEmpty()) {
                    return;
                }
                Bukkit.getRegionScheduler().run((Plugin)Aurora.getInstance(), player.getLocation(), t -> failed.forEach((slot, fitem) -> player.getWorld().dropItem(player.getLocation(), fitem)));
            } else if (this.stash == StashHandle.OVERFLOW) {
                HashMap failed = player.getInventory().addItem(items);
                if (failed.isEmpty()) {
                    return;
                }
                CompletableFuture.runAsync(() -> {
                    UserStashHolder stashHolder = Aurora.getUserManager().getUser(player.getUniqueId()).getStashData();
                    failed.forEach((slot, fitem) -> stashHolder.addItem((ItemStack)fitem));
                });
            }
        }, null);
    }

    @Override
    public void init(ConfigurationSection args) {
        super.init(args);
        ConfigurationSection config = args.getConfigurationSection("item");
        if (config == null) {
            Aurora.logger().warning("Item reward doesn't have a valid item configuration under the key 'item'!");
            return;
        }
        this.itemConfig = new ItemConfig();
        ConfigManager.load(this.itemConfig, config);
        if (args.contains("stash")) {
            this.stash = StashHandle.valueOf(args.getString("stash", "none").toUpperCase(Locale.ROOT));
        }
    }

    @Override
    public ThreadSafety getThreadSafety() {
        return ThreadSafety.ANY;
    }

    private ItemStack[] getItems(Player player, List<Placeholder<?>> placeholders) {
        Integer amount = this.itemConfig.getAmount();
        ItemStack item = ItemBuilder.of(this.itemConfig).placeholder(placeholders).amount(1).toItemStack(player);
        if (item == null || item.getType() == Material.AIR) {
            Aurora.logger().warning("Item reward failed to create item because the resolved item was null or AIR!");
            return null;
        }
        return ItemUtils.createStacksFromAmount(item, amount);
    }

    static enum StashHandle {
        NONE,
        OVERFLOW,
        FORCE;

    }
}

