/*
 * Decompiled with CFR 0.152.
 */
package gg.auroramc.aurora.api.reward;

import gg.auroramc.aurora.Aurora;
import gg.auroramc.aurora.api.AuroraAPI;
import gg.auroramc.aurora.api.message.Placeholder;
import gg.auroramc.aurora.api.reward.NumberReward;
import gg.auroramc.aurora.api.util.ThreadSafety;
import gg.auroramc.aurora.expansions.economy.AuroraEconomy;
import gg.auroramc.aurora.expansions.economy.EconomyExpansion;
import java.util.List;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;

public class MoneyReward
extends NumberReward {
    private String economy;
    private String currency = null;
    private boolean valid = true;

    @Override
    public void execute(Player player, long level, List<Placeholder<?>> placeholders) {
        AuroraEconomy econ = this.getEconomy();
        if (!this.valid || econ == null) {
            Aurora.logger().warning("Money reward isn't configured properly, can't give money to " + player.getName() + "!");
            return;
        }
        econ.deposit(player, this.currency == null ? "default" : this.currency, this.getValue(placeholders));
    }

    @Override
    public void init(ConfigurationSection args) {
        super.init(args);
        this.economy = args.getString("economy");
        if (this.economy == null) {
            EconomyExpansion expansion = Aurora.getExpansionManager().getExpansion(EconomyExpansion.class);
            if (expansion != null) {
                this.economy = expansion.getDefaultEconomyId();
            } else {
                this.valid = false;
                Aurora.logger().warning("Can't create money reward, no economy provider available.");
                return;
            }
        }
        this.currency = args.getString("currency", null);
        AuroraEconomy econ = this.getEconomy();
        if (AuroraAPI.getEconomy(this.economy) == null && econ != null) {
            Aurora.logger().warning("Economy provider " + this.economy + " is not available, please check your configuration. We will use the default economy provider.");
        }
        if (econ == null) {
            this.valid = false;
            Aurora.logger().warning("Can't create money reward, no economy provider available.");
            return;
        }
        if (this.currency != null && !this.isCurrencySupported(econ, this.currency)) {
            this.valid = false;
            Aurora.logger().warning("Currency " + this.currency + " is not supported by economy provider " + this.economy + ". Please check your configuration.");
        }
    }

    private AuroraEconomy getEconomy() {
        AuroraEconomy econ = AuroraAPI.getEconomy(this.economy);
        if (econ == null) {
            econ = AuroraAPI.getDefaultEconomy();
        }
        return econ;
    }

    private boolean isCurrencySupported(AuroraEconomy economy, String currency) {
        return economy.supportsCurrency() && economy.validateCurrency(currency);
    }

    @Override
    public ThreadSafety getThreadSafety() {
        AuroraEconomy econ = this.getEconomy();
        return econ == null ? ThreadSafety.SYNC_ONLY : econ.getThreadSafety();
    }
}

