/*
 * Decompiled with CFR 0.152.
 */
package gg.auroramc.aurora.api.reward;

import gg.auroramc.aurora.Aurora;
import gg.auroramc.aurora.api.AuroraAPI;
import gg.auroramc.aurora.api.expression.NumberExpression;
import gg.auroramc.aurora.api.message.Placeholder;
import gg.auroramc.aurora.api.reward.AbstractReward;
import java.util.List;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;

public abstract class NumberReward
extends AbstractReward {
    protected Double amount = null;
    protected String formula = null;

    @Override
    public void init(ConfigurationSection args) {
        super.init(args);
        if (args.contains("amount")) {
            this.amount = args.getDouble("amount");
        }
        this.formula = args.getString("formula", null);
        if (this.amount == null && this.formula == null) {
            Aurora.logger().warning("NumberReward has neither the amount or the formula key");
        }
    }

    public Double getValue(List<Placeholder<?>> placeholders) {
        if (this.amount != null) {
            return this.amount;
        }
        if (this.formula != null) {
            return NumberExpression.eval(this.formula, placeholders);
        }
        return 0.0;
    }

    @Override
    public String getDisplay(Player player, List<Placeholder<?>> placeholders) {
        Double value = this.getValue(placeholders);
        return Placeholder.execute(this.display, Placeholder.of("{value}", value), Placeholder.of("{value_int}", value.longValue()), Placeholder.of("{value_formatted}", AuroraAPI.formatNumber(value)));
    }
}

