/*
 * Decompiled with CFR 0.152.
 */
package gg.auroramc.aurora.api.reward;

import gg.auroramc.aurora.Aurora;
import gg.auroramc.aurora.api.message.Placeholder;
import gg.auroramc.aurora.api.message.Text;
import gg.auroramc.aurora.api.reward.AbstractReward;
import gg.auroramc.aurora.api.util.ThreadSafety;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.luckperms.api.LuckPermsProvider;
import net.luckperms.api.context.ContextSet;
import net.luckperms.api.context.MutableContextSet;
import net.luckperms.api.model.user.User;
import net.luckperms.api.node.Node;
import net.luckperms.api.node.NodeBuilder;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;

public class PermissionReward
extends AbstractReward {
    private List<String> permissions;
    private boolean value;
    private final Map<String, String> contexts = new HashMap<String, String>();

    @Override
    public void execute(Player player, long level, List<Placeholder<?>> placeholders) {
        if (this.permissions.isEmpty()) {
            return;
        }
        List<Node> nodes = this.buildNodes(player, placeholders);
        User user = LuckPermsProvider.get().getUserManager().getUser(player.getUniqueId());
        if (user == null) {
            Aurora.logger().warning("User " + player.getName() + " doesn't have LuckPerms user object");
            return;
        }
        for (Node node : nodes) {
            user.data().add(node);
        }
        LuckPermsProvider.get().getUserManager().saveUser(user);
    }

    @Override
    public void init(ConfigurationSection args) {
        super.init(args);
        if (args.isString("permission") && args.getString("permission") != null) {
            this.permissions = List.of(args.getString("permission"));
        } else if (args.isList("permission")) {
            this.permissions = args.getStringList("permission");
        } else {
            this.permissions = List.of();
            Aurora.logger().warning("PermissionReward doesn't have the permission key");
        }
        this.value = args.getBoolean("value", true);
        if (args.isConfigurationSection("contexts")) {
            ConfigurationSection contextSection = args.getConfigurationSection("contexts");
            for (String key : contextSection.getKeys(false)) {
                this.contexts.put(key, contextSection.getString(key));
            }
        }
    }

    public List<Node> buildNodes(Player player, List<Placeholder<?>> placeholders) {
        return this.permissions.stream().map(permission -> {
            NodeBuilder builder = Node.builder((String)Text.fillPlaceholders(player, permission, placeholders)).value(this.value);
            if (!this.contexts.isEmpty()) {
                MutableContextSet contextSet = MutableContextSet.create();
                for (Map.Entry<String, String> entry : this.contexts.entrySet()) {
                    contextSet.add(entry.getKey(), Text.fillPlaceholders(player, entry.getValue(), placeholders));
                }
                builder.withContext((ContextSet)contextSet);
            }
            return builder.build();
        }).toList();
    }

    @Override
    public ThreadSafety getThreadSafety() {
        return ThreadSafety.ASYNC_ONLY;
    }

    public List<String> getPermissions() {
        return this.permissions;
    }
}

