/*
 * Decompiled with CFR 0.152.
 */
package gg.auroramc.aurora.api.reward;

import gg.auroramc.aurora.Aurora;
import gg.auroramc.aurora.api.message.Placeholder;
import gg.auroramc.aurora.api.reward.Reward;
import gg.auroramc.aurora.api.util.ThreadSafety;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class RewardExecutor {
    public static CompletableFuture<Void> execute(List<Reward> rewards, Player player, long level, List<Placeholder<?>> placeholders) {
        ArrayList<Reward> sync = new ArrayList<Reward>();
        ArrayList<Reward> async = new ArrayList<Reward>();
        for (Reward reward : rewards) {
            if (reward.getThreadSafety() == ThreadSafety.SYNC_ONLY) {
                sync.add(reward);
                continue;
            }
            async.add(reward);
        }
        CompletableFuture<Object> syncFuture = new CompletableFuture<Object>();
        CompletableFuture<Object> asyncFuture = new CompletableFuture<Object>();
        if (!sync.isEmpty()) {
            Bukkit.getGlobalRegionScheduler().run((Plugin)Aurora.getInstance(), task -> {
                for (Reward reward : sync) {
                    reward.execute(player, level, placeholders);
                }
                syncFuture.complete(null);
            });
        } else {
            syncFuture.complete(null);
        }
        if (!async.isEmpty()) {
            Bukkit.getAsyncScheduler().runNow((Plugin)Aurora.getInstance(), task -> {
                for (Reward reward : async) {
                    reward.execute(player, level, placeholders);
                }
                asyncFuture.complete(null);
            });
        } else {
            asyncFuture.complete(null);
        }
        return CompletableFuture.allOf(syncFuture, asyncFuture);
    }
}

