/*
 * Decompiled with CFR 0.152.
 */
package gg.auroramc.aurora.api.reward;

import com.google.common.collect.Maps;
import gg.auroramc.aurora.Aurora;
import gg.auroramc.aurora.api.reward.Reward;
import gg.auroramc.aurora.api.util.NamespacedId;
import java.lang.reflect.InvocationTargetException;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import org.bukkit.configuration.ConfigurationSection;

public class RewardFactory {
    private final Map<NamespacedId, Class<? extends Reward>> rewardTypes = Maps.newConcurrentMap();

    public void registerRewardType(NamespacedId id, Class<? extends Reward> clazz) {
        this.rewardTypes.put(id, clazz);
    }

    public Optional<Reward> createReward(ConfigurationSection args) {
        if (args == null) {
            return Optional.empty();
        }
        NamespacedId type = NamespacedId.fromDefault(args.getString("type", "command").toLowerCase(Locale.ROOT));
        try {
            Class<? extends Reward> clazz = this.rewardTypes.get(type);
            if (clazz == null) {
                Aurora.logger().warning("Failed to create reward of type " + String.valueOf(type) + ": Reward type not found");
                return Optional.empty();
            }
            Reward reward = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            reward.init(args);
            return Optional.of(reward);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            Aurora.logger().warning("Failed to create reward of type " + String.valueOf(type) + ": " + e.getMessage());
            return Optional.empty();
        }
    }
}

