/*
 * Decompiled with CFR 0.152.
 */
package gg.auroramc.aurora.api.user;

import com.google.common.collect.Maps;
import gg.auroramc.aurora.Aurora;
import gg.auroramc.aurora.api.user.DataHolder;
import gg.auroramc.aurora.api.user.UserDataHolder;
import gg.auroramc.aurora.api.user.UserLocalizationHolder;
import gg.auroramc.aurora.api.user.UserMetaHolder;
import gg.auroramc.aurora.api.user.UserStashHolder;
import gg.auroramc.aurora.expansions.leaderboard.model.LbEntry;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;

public class AuroraUser {
    private final Map<Class<? extends UserDataHolder>, UserDataHolder> dataHolderMap = new ConcurrentHashMap<Class<? extends UserDataHolder>, UserDataHolder>();
    private YamlConfiguration configuration;
    private final UUID uuid;
    private final Object serializeLock = new Object();
    private final AtomicBoolean loaded = new AtomicBoolean(true);
    private final Map<String, Double> originalLeaderboardValues = Maps.newConcurrentMap();
    private final Map<String, LbEntry> leaderboardEntries = Maps.newConcurrentMap();

    public void updateOriginalLeaderboardDataFromCurrent() {
        this.originalLeaderboardValues.clear();
        for (Map.Entry<String, LbEntry> entry : this.leaderboardEntries.entrySet()) {
            this.originalLeaderboardValues.put(entry.getKey(), entry.getValue().getValue());
        }
    }

    public Map<String, Double> getDirtyLeaderboards() {
        HashMap dirty = Maps.newHashMap();
        for (Map.Entry<String, LbEntry> entry : this.leaderboardEntries.entrySet()) {
            if (this.originalLeaderboardValues.containsKey(entry.getKey())) {
                if (this.originalLeaderboardValues.get(entry.getKey()).equals(entry.getValue().getValue())) continue;
                dirty.put(entry.getKey(), entry.getValue().getValue());
                continue;
            }
            dirty.put(entry.getKey(), entry.getValue().getValue());
        }
        return dirty;
    }

    public AuroraUser(UUID uuid) {
        this.uuid = uuid;
    }

    public AuroraUser(UUID uuid, boolean isLoaded) {
        this.uuid = uuid;
        this.loaded.set(isLoaded);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initData(YamlConfiguration data, Set<Class<? extends UserDataHolder>> dataHolders) {
        Object object = this.serializeLock;
        synchronized (object) {
            boolean isLoaded = this.loaded.get();
            if (data != null) {
                this.configuration = data;
            }
            for (Class<? extends UserDataHolder> holderClass : dataHolders) {
                try {
                    UserDataHolder holder = holderClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    holder.setUuid(this.uuid);
                    if (isLoaded && data != null) {
                        holder.initFrom(data.getConfigurationSection(holder.getId().toString()));
                    }
                    this.dataHolderMap.put(holderClass, holder);
                }
                catch (Exception e) {
                    Aurora.logger().warning("Failed to initialize data holder: " + holderClass.getSimpleName() + " error: " + e.getMessage());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void loadFromUser(AuroraUser user) {
        Object object = this.serializeLock;
        synchronized (object) {
            this.configuration = user.configuration;
            this.dataHolderMap.clear();
            this.dataHolderMap.putAll(user.dataHolderMap);
            for (UserDataHolder holder : this.dataHolderMap.values()) {
                holder.setUuid(this.uuid);
            }
            this.loaded.set(true);
        }
    }

    public <T extends DataHolder> T getData(Class<T> holderClass) {
        Aurora.getUserManager().isUserCached(this.uuid);
        if (this.dataHolderMap.containsKey(holderClass)) {
            return (T)((DataHolder)holderClass.cast(this.dataHolderMap.get(holderClass)));
        }
        return null;
    }

    public UserMetaHolder getMetaData() {
        return this.getData(UserMetaHolder.class);
    }

    public UserStashHolder getStashData() {
        return this.getData(UserStashHolder.class);
    }

    public UserLocalizationHolder getLocalizationData() {
        return this.getData(UserLocalizationHolder.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public YamlConfiguration serializeData() {
        Object object = this.serializeLock;
        synchronized (object) {
            if (this.configuration == null) {
                Aurora.logger().debug("Configuration is null for user: " + String.valueOf(this.uuid) + " when calling AuroraUser#serializeData");
            }
            for (UserDataHolder holder : this.dataHolderMap.values()) {
                holder.serializeInto(this.getOrCreateSection(holder.getId().toString()));
            }
            return this.configuration;
        }
    }

    public Collection<UserDataHolder> getDataHolders() {
        return this.dataHolderMap.values();
    }

    private ConfigurationSection getOrCreateSection(String path) {
        if (this.configuration.getConfigurationSection(path) != null) {
            return this.configuration.getConfigurationSection(path);
        }
        return this.configuration.createSection(path);
    }

    public UUID getUniqueId() {
        return this.uuid;
    }

    public Player getPlayer() {
        return Bukkit.getPlayer((UUID)this.uuid);
    }

    public OfflinePlayer getOfflinePlayer() {
        return Bukkit.getOfflinePlayer((UUID)this.uuid);
    }

    public boolean isLoaded() {
        return this.loaded.get();
    }

    public void setLoaded(boolean loaded) {
        this.loaded.set(loaded);
    }

    public boolean isDirty() {
        return this.dataHolderMap.values().stream().anyMatch(UserDataHolder::isDirty);
    }

    public static AuroraUser get(UUID uuid) {
        return Aurora.getUserManager().getUser(uuid);
    }

    public YamlConfiguration getConfiguration() {
        return this.configuration;
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public Object getSerializeLock() {
        return this.serializeLock;
    }

    public Map<String, LbEntry> getLeaderboardEntries() {
        return this.leaderboardEntries;
    }
}

