/*
 * Decompiled with CFR 0.152.
 */
package gg.auroramc.aurora.api.user;

import gg.auroramc.aurora.api.user.UserDataHolder;
import gg.auroramc.aurora.api.util.NamespacedId;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicReference;
import org.bukkit.configuration.ConfigurationSection;
import org.jetbrains.annotations.Nullable;

public class UserLocalizationHolder
extends UserDataHolder {
    private final AtomicReference<Locale> localization = new AtomicReference<Locale>(Locale.ROOT);

    public Locale getLocalization() {
        return this.localization.get();
    }

    public void setLocalization(Locale localization) {
        this.localization.set(localization);
        this.dirty.set(true);
    }

    @Override
    public NamespacedId getId() {
        return NamespacedId.fromDefault("localization");
    }

    @Override
    public void serializeInto(ConfigurationSection data) {
        Locale locale = this.localization.get();
        if (locale != Locale.ROOT) {
            data.set("language", (Object)locale.toLanguageTag());
        } else {
            data.set("language", null);
        }
    }

    @Override
    public void initFrom(@Nullable ConfigurationSection data) {
        if (data == null) {
            return;
        }
        if (data.contains("language")) {
            this.setLocalization(Locale.forLanguageTag(data.getString("language")));
        }
    }
}

